/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.blocks.BlockSapling;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.VectUtil;
import forestry.core.worldgen.FeatureBase;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.template.Template;

public abstract class FeatureArboriculture
extends FeatureBase {
    protected static final int minPodHeight = 3;
    protected final ITreeGenData tree;

    protected FeatureArboriculture(ITreeGenData tree) {
        this.tree = tree;
    }

    @Override
    public boolean place(IWorld world, Random rand, BlockPos pos, boolean forced) {
        GameProfile owner = FeatureArboriculture.getOwner(world, pos);
        TreeBlockTypeLeaf leaf = new TreeBlockTypeLeaf(this.tree, owner, rand);
        TreeBlockTypeLog wood = new TreeBlockTypeLog(this.tree);
        this.preGenerate(world, rand, pos);
        BlockPos genPos = forced ? pos : this.getValidGrowthPos(world, pos);
        if (genPos != null) {
            this.clearSaplings(world, genPos);
            ArrayList<BlockPos> branchEnds = new ArrayList<BlockPos>(this.generateTrunk(world, rand, wood, genPos));
            branchEnds.sort(VectUtil.TOP_DOWN_COMPARATOR);
            TreeContour.Impl contour = new TreeContour.Impl(branchEnds);
            this.generateLeaves(world, rand, leaf, contour, genPos);
            this.generateExtras(world, rand, genPos);
            this.updateLeaves(world, contour);
            VoxelShapePart voxelshapepart = this.updateLeaves(world, contour);
            Template.func_222857_a((IWorld)world, (int)3, (VoxelShapePart)voxelshapepart, (int)contour.boundingBox.field_78897_a, (int)contour.boundingBox.field_78895_b, (int)contour.boundingBox.field_78896_c);
            return true;
        }
        return false;
    }

    @Nullable
    private static GameProfile getOwner(IWorld world, BlockPos pos) {
        TileTreeContainer tile = TileUtil.getTile((IBlockReader)world, pos, TileTreeContainer.class);
        if (tile == null) {
            return null;
        }
        return tile.getOwnerHandler().getOwner();
    }

    public void preGenerate(IWorld world, Random rand, BlockPos startPos) {
    }

    private VoxelShapePart updateLeaves(IWorld world, TreeContour.Impl contour) {
        MutableBoundingBox boundingBox = contour.boundingBox;
        ArrayList list = Lists.newArrayList();
        BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(boundingBox.func_78883_b(), boundingBox.func_78882_c(), boundingBox.func_78880_d());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (BlockPos blockpos1 : Lists.newArrayList(contour.leavePositions)) {
            if (boundingBox.func_175898_b((Vector3i)blockpos1)) {
                voxelshapepart.func_199625_a(blockpos1.func_177958_n() - boundingBox.field_78897_a, blockpos1.func_177956_o() - boundingBox.field_78895_b, blockpos1.func_177952_p() - boundingBox.field_78896_c, true, true);
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutable.func_239622_a_((Vector3i)blockpos1, direction);
                if (contour.leavePositions.contains(blockpos$mutable) || !(blockstate = world.func_180495_p((BlockPos)blockpos$mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                ((Set)list.get(0)).add(blockpos$mutable.func_185334_h());
                TreeFeature.func_236408_b_((IWorldWriter)world, (BlockPos)blockpos$mutable, (BlockState)((BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1))));
                if (!boundingBox.func_175898_b((Vector3i)blockpos$mutable)) continue;
                voxelshapepart.func_199625_a(blockpos$mutable.func_177958_n() - boundingBox.field_78897_a, blockpos$mutable.func_177956_o() - boundingBox.field_78895_b, blockpos$mutable.func_177952_p() - boundingBox.field_78896_c, true, true);
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (boundingBox.func_175898_b((Vector3i)blockpos2)) {
                    voxelshapepart.func_199625_a(blockpos2.func_177958_n() - boundingBox.field_78897_a, blockpos2.func_177956_o() - boundingBox.field_78895_b, blockpos2.func_177952_p() - boundingBox.field_78896_c, true, true);
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutable.func_239622_a_((Vector3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutable) || set1.contains(blockpos$mutable) || !(blockstate1 = world.func_180495_p((BlockPos)blockpos$mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa) || (k = ((Integer)blockstate1.func_177229_b((Property)BlockStateProperties.field_208514_aa)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(l + 1));
                    TreeFeature.func_236408_b_((IWorldWriter)world, (BlockPos)blockpos$mutable, (BlockState)blockstate2);
                    if (boundingBox.func_175898_b((Vector3i)blockpos$mutable)) {
                        voxelshapepart.func_199625_a(blockpos$mutable.func_177958_n() - boundingBox.field_78897_a, blockpos$mutable.func_177956_o() - boundingBox.field_78895_b, blockpos$mutable.func_177952_p() - boundingBox.field_78896_c, true, true);
                    }
                    set1.add(blockpos$mutable.func_185334_h());
                }
            }
        }
        return voxelshapepart;
    }

    protected abstract Set<BlockPos> generateTrunk(IWorld var1, Random var2, TreeBlockTypeLog var3, BlockPos var4);

    protected abstract void generateLeaves(IWorld var1, Random var2, TreeBlockTypeLeaf var3, TreeContour var4, BlockPos var5);

    protected abstract void generateExtras(IWorld var1, Random var2, BlockPos var3);

    @Nullable
    public abstract BlockPos getValidGrowthPos(IWorld var1, BlockPos var2);

    public void clearSaplings(IWorld world, BlockPos genPos) {
        int treeGirth = this.tree.getGirth();
        for (int x = 0; x < treeGirth; ++x) {
            for (int z = 0; z < treeGirth; ++z) {
                BlockPos saplingPos = genPos.func_177982_a(x, 0, z);
                if (!(world.func_180495_p(saplingPos).func_177230_c() instanceof BlockSapling)) continue;
                world.func_180501_a(saplingPos, Blocks.field_150350_a.func_176223_P(), 18);
            }
        }
    }

    public boolean hasPods() {
        return this.tree.allowsFruitBlocks();
    }
}

