/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class FeatureIpe
extends FeatureTree {
    public FeatureIpe(ITreeGenData tree) {
        super(tree, 6, 4);
    }

    @Override
    public Set<BlockPos> generateTrunk(IWorld world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        float adjustedGirth = (float)this.girth * 0.65f;
        HashSet<BlockPos> branchCoords = new HashSet<BlockPos>();
        for (int trunkSpawn = this.height - 2; trunkSpawn > 2; trunkSpawn -= 2) {
            int radius = Math.round(adjustedGirth * (float)(this.height - trunkSpawn) / 1.5f);
            branchCoords.addAll(FeatureHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, trunkSpawn, 0), this.girth, 0.25f, 0.25f, radius, 2, 1.0f));
        }
        return branchCoords;
    }

    @Override
    protected void generateLeaves(IWorld world, Random rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int leafSpawn = this.height + 1;
        float adjustedGirth = (float)this.girth * 0.65f;
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 0.2f * adjustedGirth + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 0.2f * adjustedGirth + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        for (BlockPos branchEnd : contour.getBranchEnds()) {
            FeatureHelper.generateCylinderFromPos(world, leaf, branchEnd, 2.0f + (float)this.girth, 2, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
    }
}

