/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTreeVanilla;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class FeatureJungle
extends FeatureTreeVanilla {
    public FeatureJungle(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public Set<BlockPos> generateTrunk(IWorld world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        int height = this.height;
        float vinesChance = 0.0f;
        if (this.girth >= 2) {
            height = (int)((float)height * 1.5f);
            vinesChance = 0.8f;
        }
        FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, height, this.girth, 0, vinesChance, null, 0.0f);
        HashSet<BlockPos> branchCoords = new HashSet<BlockPos>();
        if (height > 10) {
            for (int branchSpawn = 6; branchSpawn < height - 2; branchSpawn += rand.nextInt(4)) {
                branchCoords.addAll(FeatureHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, branchSpawn, 0), this.girth, 0.5f, 0.0f, 2, 1, 0.25f));
            }
        }
        return branchCoords;
    }

    @Override
    protected void generateLeaves(IWorld world, Random rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int height = this.height;
        if (this.girth >= 2) {
            height = (int)((float)height * 1.5f);
        }
        for (BlockPos branchEnd : contour.getBranchEnds()) {
            FeatureHelper.generateCylinderFromPos(world, leaf, branchEnd, this.girth, 1, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
        int leafSpawn = height + 1;
        float canopyRadiusMultiplier = (float)height / 7.0f;
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 0.5f * canopyRadiusMultiplier + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.9f * canopyRadiusMultiplier + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 1.9f * canopyRadiusMultiplier + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
    }
}

