/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class FeatureSpruce
extends FeatureTree {
    public FeatureSpruce(ITreeGenData tree) {
        super(tree, 5, 3);
    }

    @Override
    public Set<BlockPos> generateTrunk(IWorld world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        HashSet<BlockPos> branchEnds = new HashSet<BlockPos>();
        int branchSpawn = this.height - 1;
        int branchWidth = this.height / 4;
        while (branchSpawn > 2) {
            branchEnds.addAll(FeatureHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, branchSpawn, 0), this.girth, 0.2f, 0.5f, branchWidth, 1, 1.0f));
            branchSpawn -= 2;
            ++branchWidth;
        }
        return branchEnds;
    }

    @Override
    protected void generateLeaves(IWorld world, Random rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int leafSpawn = this.height + 1;
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.0f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        int leafRadius = 4;
        for (BlockPos branchEnd : contour.getBranchEnds()) {
            FeatureHelper.generateCircle(world, rand, branchEnd, leafRadius, 3, 2, leaf, 1.0f, FeatureHelper.EnumReplaceMode.SOFT, contour);
        }
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 2.0f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 1.0f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
    }
}

