/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.worldgen.FeatureArboriculture;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public abstract class FeatureTree
extends FeatureArboriculture {
    private static final int minHeight = 4;
    private static final int maxHeight = 80;
    private final int baseHeight;
    private final int heightVariation;
    protected int girth;
    protected int height;

    protected FeatureTree(ITreeGenData tree, int baseHeight, int heightVariation) {
        super(tree);
        this.baseHeight = baseHeight;
        this.heightVariation = heightVariation;
    }

    @Override
    public Set<BlockPos> generateTrunk(IWorld world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        return Collections.emptySet();
    }

    @Override
    protected void generateLeaves(IWorld world, Random rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int leafHeight = this.height + 1;
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafHeight--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.AIR, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafHeight--, 0), this.girth, 0.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.AIR, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafHeight--, 0), this.girth, 1.9f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.AIR, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafHeight, 0), this.girth, 1.9f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.AIR, contour);
    }

    @Override
    protected void generateExtras(IWorld world, Random rand, BlockPos startPos) {
        if (this.hasPods()) {
            FeatureHelper.generatePods(this.tree, world, rand, startPos, this.height, 3, this.girth, FeatureHelper.EnumReplaceMode.AIR);
        }
    }

    @Override
    @Nullable
    public BlockPos getValidGrowthPos(IWorld world, BlockPos pos) {
        return this.tree.canGrow(world, pos, this.girth, this.height);
    }

    @Override
    public final void preGenerate(IWorld world, Random rand, BlockPos startPos) {
        super.preGenerate(world, rand, startPos);
        this.height = this.determineHeight(world, rand, this.baseHeight, this.heightVariation);
        this.girth = this.tree.getGirth();
    }

    protected int modifyByHeight(IWorld world, int val, int min, int max) {
        ITreekeepingMode treeModifier = TreeManager.treeRoot.getTreekeepingMode(world);
        int determined = Math.round((float)val * this.tree.getHeightModifier() * treeModifier.getHeightModifier(this.tree.getGenome(), 1.0f));
        return determined < min ? min : Math.min(determined, max);
    }

    private int determineHeight(IWorld world, Random rand, int required, int variation) {
        ITreekeepingMode treeModifier = TreeManager.treeRoot.getTreekeepingMode(world);
        int baseHeight = required + rand.nextInt(variation);
        int height = Math.round((float)baseHeight * this.tree.getHeightModifier() * treeModifier.getHeightModifier(this.tree.getGenome(), 1.0f));
        return height < 4 ? 4 : Math.min(height, 80);
    }
}

