/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class FeatureWillow
extends FeatureTree {
    public FeatureWillow(ITreeGenData tree) {
        super(tree, 5, 2);
    }

    @Override
    public Set<BlockPos> generateTrunk(IWorld world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.8f, null, 0.0f);
        FeatureHelper.generateSupportStems(wood, world, rand, startPos, this.height, this.girth, 0.2f, 0.2f);
        for (int leafSpawn = this.height - 4; leafSpawn > 2; --leafSpawn) {
            if ((leafSpawn - 3) % 6 != 0) continue;
            FeatureHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 0.0f, 0.0f, 2, 1, 1.0f);
        }
        return Collections.emptySet();
    }

    @Override
    protected void generateLeaves(IWorld world, Random rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        int leafSpawn = this.height + 1;
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 2.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 3.0f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 3.0f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        while (leafSpawn > 2) {
            FeatureHelper.generateCircleFromTreeStartPos(world, rand, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 4.0f, 2, 1, leaf, 1.0f, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
        FeatureHelper.generateCircleFromTreeStartPos(world, rand, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 4.0f, 1, 1, leaf, 1.0f, FeatureHelper.EnumReplaceMode.AIR, contour);
        FeatureHelper.generateCircleFromTreeStartPos(world, rand, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 4.0f, 1, 1, leaf, 1.0f, FeatureHelper.EnumReplaceMode.AIR, contour);
        FeatureHelper.generateCircleFromTreeStartPos(world, rand, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 4.0f, 1, 1, leaf, 0.4f, FeatureHelper.EnumReplaceMode.AIR, contour);
    }
}

