/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITreeGenData;
import forestry.arboriculture.worldgen.FeatureTree;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.TreeContour;
import forestry.core.worldgen.FeatureHelper;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class FeatureZebrawood
extends FeatureTree {
    public FeatureZebrawood(ITreeGenData tree) {
        super(tree, 8, 8);
    }

    @Override
    public Set<BlockPos> generateTrunk(IWorld world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        FeatureHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        FeatureHelper.generateSupportStems(wood, world, rand, startPos, this.height, this.girth, 0.8f, 0.3f);
        return FeatureHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, this.height - 4, 0), this.girth, 0.0f, 0.25f, 3, 2, 0.75f);
    }

    @Override
    protected void generateLeaves(IWorld world, Random rand, TreeBlockTypeLeaf leaf, TreeContour contour, BlockPos startPos) {
        for (BlockPos branchEnd : contour.getBranchEnds()) {
            FeatureHelper.generateCylinderFromPos(world, leaf, branchEnd, 1.0f + (float)this.girth, 2, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
        int leafSpawn = this.height + 1;
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 0.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.9f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        while (leafSpawn > this.height - 4) {
            FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 2.5f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        }
        FeatureHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 1.9f + (float)this.girth, 1, FeatureHelper.EnumReplaceMode.SOFT, contour);
        for (int times = 0; times < this.height / 4; ++times) {
            int h = 10 + rand.nextInt(Math.max(1, this.height - 10));
            if (rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + rand.nextInt(this.height / 2);
            }
            int x_off = -1 + rand.nextInt(3);
            int y_off = -1 + rand.nextInt(3);
            FeatureHelper.generateSphere(world, startPos.func_177982_a(x_off, h, y_off), 1 + rand.nextInt(1), leaf, FeatureHelper.EnumReplaceMode.AIR, contour);
        }
    }
}

