/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;

public interface TreeContour {
    public static final TreeContour EMPTY = new Empty();

    default public void addLeaf(BlockPos pos) {
    }

    default public Collection<BlockPos> getBranchEnds() {
        return Collections.emptyList();
    }

    public static class Empty
    implements TreeContour {
        private Empty() {
        }
    }

    public static class Impl
    implements TreeContour {
        public final Set<BlockPos> leavePositions = new HashSet<BlockPos>();
        public final List<BlockPos> branchEnds;
        public final MutableBoundingBox boundingBox;

        public Impl(List<BlockPos> branchEnds) {
            this.branchEnds = branchEnds;
            this.boundingBox = MutableBoundingBox.func_78887_a();
        }

        @Override
        public void addLeaf(BlockPos pos) {
            this.leavePositions.add(pos.func_185334_h());
            this.boundingBox.func_78888_b(new MutableBoundingBox((Vector3i)pos, (Vector3i)pos));
        }

        public List<BlockPos> getBranchEnds() {
            return this.branchEnds;
        }
    }
}

