/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.IAlleleTreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.TreeChromosomes;
import forestry.arboriculture.TreeConfig;
import forestry.arboriculture.commands.TreeGenHelper;
import forestry.core.config.Config;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Log;
import genetics.api.GeneticsAPI;
import genetics.api.alleles.IAllele;
import genetics.api.individual.IGenome;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.registries.ForgeRegistries;

public class TreeDecorator
extends Feature<NoFeatureConfig> {
    private static final List<IAlleleTreeSpecies> SPECIES = new ArrayList<IAlleleTreeSpecies>();
    private static final Map<ResourceLocation, Set<ITree>> biomeCache = new HashMap<ResourceLocation, Set<ITree>>();

    public TreeDecorator() {
        super(NoFeatureConfig.field_236558_a_);
    }

    @Nullable
    private static BlockPos getValidPos(ISeedReader world, int x, int z, ITree tree) {
        BlockPos topPos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(x, 0, z));
        if (topPos.func_177956_o() == 0) {
            return null;
        }
        BlockPos.Mutable pos = new BlockPos.Mutable(topPos.func_177958_n(), topPos.func_177956_o(), topPos.func_177952_p());
        BlockState blockState = world.func_180495_p((BlockPos)pos);
        while (BlockUtil.canReplace(blockState, (IWorld)world, (BlockPos)pos)) {
            pos.func_189536_c(Direction.DOWN);
            if (pos.func_177956_o() <= 0) {
                return null;
            }
            blockState = world.func_180495_p((BlockPos)pos);
        }
        if (tree instanceof IPlantable && blockState.func_177230_c().canSustainPlant(blockState, (IBlockReader)world, (BlockPos)pos, Direction.UP, (IPlantable)tree)) {
            return pos.func_177984_a();
        }
        return null;
    }

    private static List<IAlleleTreeSpecies> getSpecies() {
        if (!SPECIES.isEmpty()) {
            return SPECIES;
        }
        for (IAllele allele : GeneticsAPI.apiInstance.getAlleleRegistry().getRegisteredAlleles(TreeChromosomes.SPECIES)) {
            IAlleleTreeSpecies alleleTreeSpecies;
            if (!(allele instanceof IAlleleTreeSpecies) || !(TreeConfig.getSpawnRarity((alleleTreeSpecies = (IAlleleTreeSpecies)allele).getRegistryName()) > 0.0f)) continue;
            SPECIES.add(alleleTreeSpecies);
        }
        return SPECIES;
    }

    private static void generateBiomeCache(ISeedReader world, Random rand) {
        for (IAlleleTreeSpecies species : TreeDecorator.getSpecies()) {
            IAllele[] template = TreeManager.treeRoot.getTemplate(species.getRegistryName().toString());
            IGenome genome = ((ITree)TreeManager.treeRoot.templateAsIndividual(template)).getGenome();
            ITree tree = TreeManager.treeRoot.getTree((World)world.func_201672_e(), genome);
            ResourceLocation treeUID = genome.getPrimary().getRegistryName();
            IGrowthProvider growthProvider = species.getGrowthProvider();
            for (Biome biome : ForgeRegistries.BIOMES) {
                Set trees = biomeCache.computeIfAbsent(WorldGenRegistries.field_243657_i.func_177774_c((Object)biome), k -> new HashSet());
                if (!growthProvider.isBiomeValid(tree, biome) || !TreeConfig.isValidBiome(treeUID, biome)) continue;
                trees.add(tree);
            }
        }
    }

    public boolean place(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        float globalRarity = TreeConfig.getSpawnRarity(null);
        if (globalRarity <= 0.0f || !TreeConfig.isValidDimension(null, (RegistryKey<World>)seedReader.func_201672_e().func_234923_W_())) {
            return false;
        }
        if (biomeCache.isEmpty()) {
            TreeDecorator.generateBiomeCache(seedReader, rand);
        }
        for (int tries = 0; tries < 4 + rand.nextInt(2); ++tries) {
            int x = pos.func_177958_n() + rand.nextInt(16);
            int z = pos.func_177952_p() + rand.nextInt(16);
            Biome biome = seedReader.func_226691_t_(pos);
            ResourceLocation biomeName = seedReader.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
            Set trees = biomeCache.computeIfAbsent(biomeName, k -> new HashSet());
            for (ITree tree : trees) {
                BlockPos validPos;
                IAlleleTreeSpecies species;
                ResourceLocation treeUID = tree.getGenome().getPrimary().getRegistryName();
                if (!TreeConfig.isValidDimension(treeUID, (RegistryKey<World>)seedReader.func_201672_e().func_234923_W_()) || !(TreeConfig.getSpawnRarity((species = tree.getGenome().getActiveAllele(TreeChromosomes.SPECIES)).getRegistryName()) * globalRarity >= rand.nextFloat()) || (validPos = TreeDecorator.getValidPos(seedReader, x, z, tree)) == null || !species.getGrowthProvider().canSpawn(tree, (World)seedReader.func_201672_e(), validPos) || !TreeGenHelper.generateTree(tree, seedReader, validPos)) continue;
                if (Config.logTreePlacement) {
                    Log.info("Placed {} at {}", treeUID.toString(), pos.toString());
                }
                return true;
            }
        }
        return false;
    }
}

