/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.gui;

import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.climatology.features.ClimatologyContainers;
import forestry.climatology.tiles.TileHabitatFormer;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.gui.ContainerLiquidTanksHelper;
import forestry.core.gui.ContainerTile;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotLiquidIn;
import forestry.core.network.IStreamableGui;
import forestry.core.network.packets.PacketGuiUpdate;
import forestry.core.tiles.TileUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidTank;

public class ContainerHabitatFormer
extends ContainerTile<TileHabitatFormer>
implements IContainerLiquidTanks,
IGuiSelectable {
    static final int REQUEST_ID_CIRCLE = 0;
    static final int REQUEST_ID_RANGE = 1;
    private IClimateState previousState = ClimateStateHelper.INSTANCE.absent();
    private IClimateState previousTarget = ClimateStateHelper.INSTANCE.absent();
    private IClimateState previousDefault = ClimateStateHelper.INSTANCE.absent();
    private int previousRange;
    private boolean previousCircular;
    private final ContainerLiquidTanksHelper<TileHabitatFormer> helper;

    public static ContainerHabitatFormer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer extraData) {
        TileHabitatFormer tile = TileUtil.getTile((IBlockReader)inv.field_70458_d.field_70170_p, extraData.func_179259_c(), TileHabitatFormer.class);
        return new ContainerHabitatFormer(windowId, inv, tile);
    }

    public ContainerHabitatFormer(int windowId, PlayerInventory playerInventory, TileHabitatFormer tile) {
        super(windowId, ClimatologyContainers.HABITAT_FORMER.containerType(), playerInventory, tile, 8, 151);
        this.helper = new ContainerLiquidTanksHelper<TileHabitatFormer>(tile);
        this.func_75146_a(new SlotLiquidIn(tile, 0, 129, 38));
    }

    @Override
    public void func_75142_b() {
        boolean circular;
        int range;
        IClimateState defaultState;
        IClimateState target;
        super.func_75142_b();
        boolean guiNeedsUpdate = false;
        IClimateTransformer transformer = ((TileHabitatFormer)this.tile).getTransformer();
        IClimateState state = transformer.getCurrent();
        if (!this.previousState.equals(state)) {
            this.previousState = state;
            guiNeedsUpdate = true;
        }
        if (!this.previousTarget.equals(target = transformer.getTarget())) {
            this.previousTarget = target;
            guiNeedsUpdate = true;
        }
        if (!this.previousDefault.equals(defaultState = transformer.getDefault())) {
            this.previousDefault = defaultState;
            guiNeedsUpdate = true;
        }
        if ((range = transformer.getRange()) != this.previousRange) {
            this.previousRange = range;
            guiNeedsUpdate = true;
        }
        if ((circular = transformer.isCircular()) != this.previousCircular) {
            this.previousCircular = circular;
            guiNeedsUpdate = true;
        }
        if (guiNeedsUpdate) {
            PacketGuiUpdate packet = new PacketGuiUpdate((IStreamableGui)this.tile);
            this.sendPacketToListeners(packet);
        }
        ((TileHabitatFormer)this.tile).getTankManager().sendTankUpdate(this, this.field_75149_d);
    }

    @Override
    public void handleSelectionRequest(ServerPlayerEntity player, int primary, int secondary) {
        IClimateTransformer transformer = ((TileHabitatFormer)this.tile).getTransformer();
        switch (primary) {
            case 0: {
                transformer.setCircular(secondary == 1);
                break;
            }
            case 1: {
                transformer.setRange(secondary);
                break;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePipetteClickClient(int slot, PlayerEntity player) {
        this.helper.handlePipetteClickClient(slot, player);
    }

    @Override
    public void handlePipetteClick(int slot, ServerPlayerEntity player) {
        this.helper.handlePipetteClick(slot, player);
    }

    public void func_75132_a(IContainerListener crafting) {
        super.func_75132_a(crafting);
        ((TileHabitatFormer)this.tile).getTankManager().containerAdded(this, crafting);
    }

    public void func_75134_a(PlayerEntity PlayerEntity2) {
        super.func_75134_a(PlayerEntity2);
        ((TileHabitatFormer)this.tile).getTankManager().containerRemoved(this);
    }

    @Override
    public IFluidTank getTank(int slot) {
        return ((TileHabitatFormer)this.tile).getTankManager().getTank(slot);
    }
}

