/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.api.core.tooltips.ToolTip;
import forestry.climatology.gui.ContainerHabitatFormer;
import forestry.climatology.gui.elements.ClimateBarElement;
import forestry.climatology.gui.elements.HabitatSelectionElement;
import forestry.climatology.gui.elements.SpeciesSelectionElement;
import forestry.climatology.network.packets.PacketSelectClimateTargeted;
import forestry.climatology.tiles.TileHabitatFormer;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.elements.Alignment;
import forestry.core.gui.elements.ButtonElement;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.ScrollBarElement;
import forestry.core.gui.elements.TextEditElement;
import forestry.core.gui.elements.layouts.ContainerElement;
import forestry.core.gui.widgets.IScrollable;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiHabitatFormer
extends GuiForestryTitled<ContainerHabitatFormer>
implements IScrollable {
    public static final ResourceLocation TEXTURE = new ResourceLocation("forestry", "textures/gui/habitat_former.png");
    private static final Drawable TEMPERATURE_FIELD = new Drawable(TEXTURE, 204, 22, 52, 12);
    private static final Drawable HUMIDITY_FIELD = new Drawable(TEXTURE, 204, 34, 52, 12);
    private static final Drawable SCROLLBAR_SLIDER = new Drawable(TEXTURE, 176, 92, 12, 15);
    private static final Drawable CIRCLE_ENABLED_BUTTON = new Drawable(TEXTURE, 238, 110, 18, 18);
    private static final Drawable CIRCLE_DISABLED_BUTTON = new Drawable(TEXTURE, 220, 110, 18, 18);
    private final TileHabitatFormer tile;
    private final IClimateTransformer transformer;
    private final ScrollBarElement rangeBar;
    private final TextEditElement temperatureEdit;
    private final TextEditElement humidityEdit;

    public GuiHabitatFormer(ContainerHabitatFormer container, PlayerInventory inv, ITextComponent title) {
        super("textures/gui/habitat_former.png", container, inv, title);
        this.tile = (TileHabitatFormer)container.getTile();
        this.transformer = this.tile.getTransformer();
        this.field_147000_g = 233;
        this.widgetManager.add(new TankWidget(this.widgetManager, 152, 17, 0));
        this.window.add(new ClimateBarElement(61, 33, this.transformer, ClimateType.TEMPERATURE));
        this.window.add(new ClimateBarElement(61, 57, this.transformer, ClimateType.HUMIDITY));
        this.rangeBar = this.window.add(new ScrollBarElement(SCROLLBAR_SLIDER)).setParameters(this, 1, 16, 1);
        this.rangeBar.setPreferredBounds(10, 17, 12, 58);
        this.rangeBar.addTooltip((tooltip, element, mouseX, mouseY) -> {
            tooltip.add((ITextComponent)new TranslationTextComponent("for.gui.habitat_former.climate.range"));
            tooltip.add((ITextComponent)new TranslationTextComponent("for.gui.habitat_former.climate.range.blocks", new Object[]{this.rangeBar.getValue()}).func_240699_a_(TextFormatting.GRAY));
        });
        this.window.add(new CircleButton(30, 37));
        ContainerElement selectionPage = this.window.pane(8, 86, 164, 56);
        selectionPage.add(new SpeciesSelectionElement(135, 22, this.transformer));
        selectionPage.translated("for.gui.habitat_former.climate.habitats", new Object[0]).setAlign(Alignment.TOP_CENTER).setLocation(17, 3);
        selectionPage.add(new HabitatSelectionElement(67, 12, this.transformer));
        selectionPage.translated("for.gui.habitat_former.climate.temperature", new Object[0]).setAlign(Alignment.TOP_CENTER).setLocation(-49, 5);
        selectionPage.drawable(7, 15, TEMPERATURE_FIELD);
        this.temperatureEdit = selectionPage.add(new TextEditElement(3));
        this.temperatureEdit.setPos(9, 17).setSize(50, 10);
        selectionPage.drawable(7, 39, HUMIDITY_FIELD);
        selectionPage.translated("for.gui.habitat_former.climate.humidity", new Object[0]).setAlign(Alignment.TOP_CENTER).setLocation(-49, 30);
        this.humidityEdit = selectionPage.add(new TextEditElement(3));
        this.humidityEdit.setPos(9, 41).setSize(50, 10);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        IClimateState target = this.transformer.getTarget();
        if (!this.window.isFocused(this.humidityEdit)) {
            this.humidityEdit.setValue(Integer.toString((int)(MathHelper.func_76131_a((float)target.getHumidity(), (float)0.0f, (float)2.0f) * 100.0f)));
        }
        if (!this.window.isFocused(this.temperatureEdit)) {
            this.temperatureEdit.setValue(Integer.toString((int)(MathHelper.func_76131_a((float)target.getTemperature(), (float)0.0f, (float)2.0f) * 100.0f)));
        }
        if (this.rangeBar.getValue() != this.transformer.getRange()) {
            this.updateRange();
        }
    }

    private void updateRange() {
        this.rangeBar.setValue(this.transformer.getRange());
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(transform, partialTicks, mouseX, mouseY);
        this.drawCenteredString(transform, Translator.translateToLocal("for.gui.habitat_former.climate.temperature"), this.field_146999_f / 2, 23);
        this.drawCenteredString(transform, Translator.translateToLocal("for.gui.habitat_former.climate.humidity"), this.field_146999_f / 2, 47);
    }

    private void drawCenteredString(MatrixStack transform, String text, int x, int y) {
        this.field_230706_i_.field_71466_p.func_238405_a_(transform, text, (float)this.field_147003_i + (float)((double)x - (double)this.field_230706_i_.field_71466_p.func_78256_a(text) / 2.0), (float)this.field_147009_r + (float)y, 0xFFFFFF);
    }

    public void setClimate(ClimateType type, String text) {
        int value;
        try {
            value = Integer.parseInt(text);
        }
        catch (NumberFormatException exception) {
            value = 0;
        }
        float climateValue = MathHelper.func_76131_a((float)((float)value / 100.0f), (float)0.0f, (float)2.0f);
        IClimateState target = this.transformer.getTarget();
        this.setClimate(target.setClimate(type, climateValue));
        this.sendClimateUpdate();
    }

    public void setClimate(IClimateState state) {
        this.transformer.setTarget(state.copy());
    }

    public void sendClimateUpdate() {
        IClimateState targetedState = this.transformer.getTarget();
        if (targetedState.isPresent()) {
            BlockPos pos = this.tile.func_174877_v();
            NetworkUtil.sendToServer(new PacketSelectClimateTargeted(pos, targetedState));
        }
    }

    public IClimateState getClimate() {
        return this.transformer.getTarget();
    }

    @Override
    protected void addLedgers() {
        this.addClimateLedger(this.tile);
        this.addErrorLedger(this.tile);
        this.addPowerLedger(this.tile.getEnergyManager());
        this.addHintLedger("habitat_former");
    }

    @Override
    public void onScroll(int value) {
        NetworkUtil.sendToServer(new PacketGuiSelectRequest(1, value));
        this.transformer.setRange(value);
    }

    @Override
    public boolean isFocused(int mouseX, int mouseY) {
        return this.rangeBar.isMouseOver();
    }

    private class CircleButton
    extends ButtonElement {
        private CircleButton(int xPos, int yPos) {
            super((ButtonElement.Builder)((ButtonElement.Builder)new ButtonElement.Builder().size(18)).textures(CIRCLE_DISABLED_BUTTON, CIRCLE_ENABLED_BUTTON).action(button -> ((CircleButton)((Object)button)).onButtonPressed()).pos(xPos, yPos));
            this.addTooltip((ToolTip tooltip, GuiElement element, int mouseX, int mouseY) -> tooltip.add((ITextComponent)new TranslationTextComponent("for.gui.habitat_former.climate.circle." + (GuiHabitatFormer.this.transformer.isCircular() ? "enabled" : "disabled"))));
        }

        private void onButtonPressed() {
            GuiHabitatFormer.this.transformer.setCircular(!GuiHabitatFormer.this.transformer.isCircular());
            NetworkUtil.sendToServer(new PacketGuiSelectRequest(0, GuiHabitatFormer.this.transformer.isCircular() ? 1 : 0));
        }

        @Override
        protected int getTextureIndex(boolean mouseOver) {
            return GuiHabitatFormer.this.transformer.isCircular() ? 1 : 0;
        }
    }
}

