/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.items;

import forestry.api.climate.IClimateHousing;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.core.climate.ClimateRoot;
import forestry.core.items.ItemForestry;
import forestry.core.items.definitions.IColoredItem;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.StringUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemHabitatScreen
extends ItemForestry
implements IColoredItem {
    public static final String POSITION_KEY = "greenhouse";
    public static final String DIMENSION_KEY = "dimension";
    public static final String PREVIEW_KEY = "preview";

    public static boolean isPreviewModeActive(ItemStack itemStack) {
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        if (compoundNBT == null || !compoundNBT.func_74764_b(PREVIEW_KEY)) {
            return false;
        }
        return compoundNBT.func_74767_n(PREVIEW_KEY);
    }

    public static void setPreviewMode(ItemStack itemStack, boolean preview) {
        itemStack.func_77983_a(PREVIEW_KEY, (INBT)ByteNBT.func_229671_a_((byte)((byte)(preview ? 1 : 0))));
    }

    @Nullable
    public static BlockPos getPosition(ItemStack itemStack) {
        CompoundNBT CompoundNBT2 = itemStack.func_77978_p();
        if (CompoundNBT2 == null || !CompoundNBT2.func_74764_b(POSITION_KEY)) {
            return null;
        }
        CompoundNBT compound = CompoundNBT2.func_74775_l(POSITION_KEY);
        if (compound.isEmpty()) {
            return null;
        }
        return NBTUtil.func_186861_c((CompoundNBT)compound);
    }

    public static int getDimension(ItemStack itemStack) {
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        if (compoundNBT == null || !compoundNBT.func_74764_b(DIMENSION_KEY)) {
            return Integer.MAX_VALUE;
        }
        return compoundNBT.func_74762_e(DIMENSION_KEY);
    }

    public static boolean isValid(ItemStack stack, @Nullable World world) {
        BlockPos pos = ItemHabitatScreen.getPosition(stack);
        int dimension = ItemHabitatScreen.getDimension(stack);
        if (pos == null || world == null || dimension == Integer.MAX_VALUE || !world.func_175667_e(pos)) {
            return false;
        }
        return TileUtil.getTile((IBlockReader)world, pos, IClimateHousing.class) != null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_225608_bj_()) {
            boolean previewModeActive = ItemHabitatScreen.isPreviewModeActive(itemStack);
            ItemHabitatScreen.setPreviewMode(itemStack, !previewModeActive);
            if (!world.field_72995_K) {
                String text = !previewModeActive ? "for.habitat_screen.mode.active" : "for.habitat_screen.mode.inactive";
                player.func_146105_b((ITextComponent)new TranslationTextComponent(text), true);
            }
        }
        return ActionResult.func_226248_a_((Object)itemStack);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        IClimateHousing housing;
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (player.func_225608_bj_() && (housing = TileUtil.getTile((IBlockReader)world, pos, IClimateHousing.class)) != null) {
            ItemStack heldItem = player.func_184586_b(context.func_221531_n());
            heldItem.func_77983_a(POSITION_KEY, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        }
        if (!world.field_72995_K) {
            IClimateState state;
            IClimateState climateState = ClimateRoot.getInstance().getState(world, pos);
            if (climateState.isPresent()) {
                state = climateState;
                if (!state.isPresent()) {
                    state = ClimateRoot.getInstance().getBiomeState(world, pos);
                }
            } else {
                state = ClimateRoot.getInstance().getBiomeState(world, pos);
            }
            if (state.isPresent()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("for.habitat_screen.status.state", new Object[]{TextFormatting.GOLD.toString() + StringUtil.floatAsPercent(state.getTemperature()), TextFormatting.BLUE.toString() + StringUtil.floatAsPercent(state.getHumidity())}), true);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("for.habitat_screen.status.nostate"), true);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (world == null) {
            return;
        }
        boolean previewModeActive = ItemHabitatScreen.isPreviewModeActive(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent(previewModeActive ? "for.habitat_screen.mode.active" : "for.habitat_screen.mode.inactive"));
        boolean isValid = ItemHabitatScreen.isValid(stack, world);
        BlockPos pos = ItemHabitatScreen.getPosition(stack);
        if (pos != null) {
            int id = 0;
            TranslationTextComponent state = isValid ? new TranslationTextComponent("for.habitat_screen.state.linked", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), id}) : new TranslationTextComponent("for.habitat_screen.state.fail");
            tooltip.add((ITextComponent)state);
        }
        if (!isValid || pos == null) {
            return;
        }
        IClimateHousing housing = TileUtil.getTile((IBlockReader)world, pos, IClimateHousing.class);
        if (housing == null) {
            return;
        }
        IClimateState climateState = housing.getTransformer().getCurrent();
        tooltip.add((ITextComponent)new TranslationTextComponent("for.habitat_screen.temperature", new Object[]{StringUtil.floatAsPercent(climateState.getTemperature())}).func_240699_a_(TextFormatting.GOLD));
        tooltip.add((ITextComponent)new TranslationTextComponent("for.habitat_screen.humidity", new Object[]{StringUtil.floatAsPercent(climateState.getHumidity())}).func_240699_a_(TextFormatting.BLUE));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int tintIndex) {
        if (tintIndex == 2) {
            return ItemHabitatScreen.isValid(stack, (World)Minecraft.func_71410_x().field_71441_e) ? 1356406 : 12197655;
        }
        if (tintIndex == 1) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (!ItemHabitatScreen.isValid(stack, (World)world)) {
                return 0xFFFFFF;
            }
            BlockPos pos = ItemHabitatScreen.getPosition(stack);
            if (pos == null) {
                return 0xFFFFFF;
            }
            IClimateHousing housing = TileUtil.getTile((IBlockReader)world, pos, IClimateHousing.class);
            if (housing == null) {
                return 0xFFFFFF;
            }
            IClimateTransformer transformer = housing.getTransformer();
            IClimateState state = transformer.getCurrent();
            return state.getTemperatureEnum().color;
        }
        return 0xFFFFFF;
    }
}

