/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.tiles;

import forestry.api.climate.ClimateCapabilities;
import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateHousing;
import forestry.api.climate.IClimateManipulator;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.api.climate.IClimatised;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.IHygroregulatorRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.climatology.features.ClimatologyTiles;
import forestry.climatology.gui.ContainerHabitatFormer;
import forestry.climatology.inventory.InventoryHabitatFormer;
import forestry.core.climate.ClimateTransformer;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.ITankManager;
import forestry.core.fluids.TankManager;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.energy.EnergyManager;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileHabitatFormer
extends TilePowered
implements IClimateHousing,
IClimatised,
ILiquidTankTile {
    private static final String TRANSFORMER_KEY = "Transformer";
    private final ClimateTransformer transformer = new ClimateTransformer(this);
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    @Nullable
    private FluidStack cachedStack = null;

    public TileHabitatFormer() {
        super(ClimatologyTiles.HABITAT_FORMER.tileType(), 1200, 10000);
        this.setInternalInventory(new InventoryHabitatFormer(this));
        this.resourceTank = new FilteredTank(10000).setFilters(() -> RecipeManagers.hygroregulatorManager.getRecipeFluids(this.field_145850_b.func_199532_z()));
        this.tankManager = new TankManager(this, this.resourceTank);
        this.setTicksPerWorkCycle(10);
        this.setEnergyPerWorkCycle(0);
    }

    @Override
    public ITankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void onRemoval() {
        this.transformer.removeTransformer();
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        this.transformer.update();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 0);
        }
    }

    @Override
    public boolean hasWork() {
        return true;
    }

    @Override
    protected boolean workCycle() {
        IErrorLogic errorLogic = this.getErrorLogic();
        IClimateState currentState = this.transformer.getCurrent();
        IClimateState changedState = this.transformer.getTarget().subtract(currentState);
        IClimateState difference = this.getClimateDifference();
        this.cachedStack = null;
        if (difference.getHumidity() != 0.0f) {
            this.updateHumidity(errorLogic, changedState);
        }
        if (difference.getTemperature() != 0.0f) {
            this.updateTemperature(errorLogic, changedState);
        }
        return true;
    }

    private void updateHumidity(IErrorLogic errorLogic, IClimateState changedState) {
        IClimateManipulator manipulator = this.transformer.createManipulator(ClimateType.HUMIDITY).build();
        if (manipulator.canAdd()) {
            errorLogic.setCondition(false, EnumErrorCode.WRONG_RESOURCE);
            int currentCost = this.getFluidCost(changedState);
            if (!this.resourceTank.drain(currentCost, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                IClimateState simulatedState = changedState.toImmutable().add(manipulator.addChange(true));
                int fluidCost = this.getFluidCost(simulatedState);
                if (!this.resourceTank.drain(fluidCost, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                    this.cachedStack = this.resourceTank.drain(fluidCost, IFluidHandler.FluidAction.EXECUTE);
                    manipulator.addChange(false);
                } else {
                    this.cachedStack = this.resourceTank.drain(currentCost, IFluidHandler.FluidAction.EXECUTE);
                }
                errorLogic.setCondition(false, EnumErrorCode.NO_RESOURCE_LIQUID);
            } else {
                manipulator.removeChange(false);
                errorLogic.setCondition(true, EnumErrorCode.NO_RESOURCE_LIQUID);
            }
        } else if (this.resourceTank.isEmpty()) {
            errorLogic.setCondition(true, EnumErrorCode.NO_RESOURCE_LIQUID);
        } else {
            errorLogic.setCondition(true, EnumErrorCode.WRONG_RESOURCE);
            errorLogic.setCondition(false, EnumErrorCode.NO_RESOURCE_LIQUID);
        }
        manipulator.finish();
    }

    private void updateTemperature(IErrorLogic errorLogic, IClimateState changedState) {
        int currentCost;
        IClimateManipulator manipulator = this.transformer.createManipulator(ClimateType.TEMPERATURE).setAllowBackwards().build();
        EnergyManager energyManager = this.getEnergyManager();
        if (energyManager.extractEnergy(currentCost = this.getEnergyCost(changedState), true) > 0) {
            IClimateState simulatedState = manipulator.addChange(true);
            int energyCost = this.getEnergyCost(simulatedState);
            if (energyManager.extractEnergy(energyCost, true) > 0) {
                energyManager.extractEnergy(energyCost, false);
                manipulator.addChange(false);
            } else {
                energyManager.extractEnergy(currentCost, false);
            }
            errorLogic.setCondition(false, EnumErrorCode.NO_POWER);
        } else {
            manipulator.removeChange(false);
            errorLogic.setCondition(true, EnumErrorCode.NO_POWER);
        }
        manipulator.finish();
    }

    private int getFluidCost(IClimateState state) {
        FluidStack fluid = this.resourceTank.getFluid();
        if (fluid == null) {
            return 0;
        }
        IHygroregulatorRecipe recipe = RecipeManagers.hygroregulatorManager.findMatchingRecipe(null, fluid);
        if (recipe == null) {
            return 0;
        }
        return Math.round((1.0f + MathHelper.func_76135_e((float)state.getHumidity())) * this.transformer.getCostModifier() * (float)recipe.getResource().getAmount());
    }

    private int getEnergyCost(IClimateState state) {
        return Math.round((1.0f + MathHelper.func_76135_e((float)state.getTemperature())) * this.transformer.getCostModifier());
    }

    @Override
    public float getChangeForState(ClimateType type, IClimateManipulator manipulator) {
        IHygroregulatorRecipe recipe;
        FluidStack fluid;
        if (type == ClimateType.HUMIDITY && (fluid = this.resourceTank.getFluid()) != null && (recipe = RecipeManagers.hygroregulatorManager.findMatchingRecipe(null, fluid)) != null) {
            return recipe.getHumidChange() / this.transformer.getSpeedModifier();
        }
        float fluidChange = 0.0f;
        if (this.cachedStack != null && (recipe = RecipeManagers.hygroregulatorManager.findMatchingRecipe(null, this.cachedStack)) != null) {
            fluidChange = Math.abs(recipe.getTempChange());
        }
        return (0.05f + fluidChange) * 0.5f / this.transformer.getSpeedModifier();
    }

    private IClimateState getClimateDifference() {
        IClimateState defaultState = this.transformer.getDefault();
        IClimateState targetedState = this.transformer.getTarget();
        return targetedState.subtract(defaultState);
    }

    @Override
    public void markNetworkUpdate() {
        this.setNeedsNetworkUpdate();
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerHabitatFormer(windowId, inv, this);
    }

    @Override
    public Biome getBiome() {
        return this.field_145850_b.func_226691_t_(this.func_174877_v());
    }

    @Override
    public float getExactTemperature() {
        return this.transformer.getCurrent().getTemperature();
    }

    @Override
    public float getExactHumidity() {
        return this.transformer.getCurrent().getHumidity();
    }

    @Override
    public IClimateTransformer getTransformer() {
        return this.transformer;
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        super.writeGuiData(data);
        this.transformer.writeData(data);
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        super.readGuiData(data);
        this.transformer.readData(data);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        this.tankManager.write(data);
        data.func_218657_a(TRANSFORMER_KEY, (INBT)this.transformer.write(new CompoundNBT()));
        return data;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT data) {
        super.func_230337_a_(state, data);
        this.tankManager.read(data);
        if (data.func_74764_b(TRANSFORMER_KEY)) {
            CompoundNBT nbtTag = data.func_74775_l(TRANSFORMER_KEY);
            this.transformer.read(nbtTag);
        }
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
        this.transformer.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
        this.transformer.readData(data);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        if (capability == ClimateCapabilities.CLIMATE_TRANSFORMER) {
            return LazyOptional.of(() -> this.transformer).cast();
        }
        return super.getCapability(capability, facing);
    }
}

