/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.climate.ClimateManager;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IWorldClimateHolder;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.network.packets.PacketClimatePlayer;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.TickHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="forestry")
public class ClimateHandlerServer {
    private static final TickHelper tickHelper = new TickHelper();
    private static IClimateState previousState = ClimateStateHelper.INSTANCE.absent();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side != LogicalSide.SERVER) {
            return;
        }
        PlayerEntity player = event.player;
        World world = player.field_70170_p;
        BlockPos pos = player.func_233580_cy_();
        IWorldClimateHolder worldClimateHolder = ClimateManager.climateRoot.getWorldClimate(world);
        IClimateState climateState = worldClimateHolder.getState(pos);
        tickHelper.onTick();
        if (tickHelper.updateOnInterval(100) && !climateState.equals(previousState)) {
            previousState = climateState;
            NetworkUtil.sendToPlayer(new PacketClimatePlayer(climateState), player);
        }
    }
}

