/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.genetics.EnumBeeType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.genetics.EnumGermlingType;
import forestry.api.core.ItemGroups;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.genetics.EnumFlutterType;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.core.features.CoreItems;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import forestry.modules.ModuleHelper;
import forestry.modules.features.FeatureProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

@FeatureProvider
public class ItemGroupForestry
extends ItemGroup {
    public static final ItemGroup tabForestry;
    private final int icon;

    public static void create() {
    }

    private ItemGroupForestry(int icon, String label) {
        super(label);
        this.icon = icon;
    }

    public ItemStack func_151244_d() {
        Object iconItem;
        switch (this.icon) {
            case 1: {
                if (ModuleHelper.isEnabled("backpacks")) {
                    iconItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry", "miner_bag"));
                    break;
                }
                iconItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry", "crate"));
                break;
            }
            case 2: {
                return BeeManager.beeRoot.getTypes().createStack(new Bee(BeeDefinition.FOREST.getGenome()), EnumBeeType.DRONE);
            }
            case 3: {
                return TreeManager.treeRoot.getTypes().createStack(new Tree(TreeDefinition.Oak.getGenome()), EnumGermlingType.SAPLING);
            }
            case 4: {
                return ButterflyManager.butterflyRoot.getTypes().createStack(new Butterfly(ButterflyDefinition.Brimstone.getGenome()), EnumFlutterType.BUTTERFLY);
            }
            default: {
                iconItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry", "fertilizer_compound"));
            }
        }
        if (iconItem == null) {
            iconItem = CoreItems.WRENCH.item();
        }
        return new ItemStack((IItemProvider)iconItem);
    }

    public ItemStack func_78016_d() {
        return this.func_151244_d();
    }

    static {
        ItemGroups.tabStorage = new ItemGroupForestry(1, "storage");
        if (ModuleHelper.isEnabled("apiculture")) {
            ItemGroups.tabApiculture = new ItemGroupForestry(2, "apiculture");
        }
        if (ModuleHelper.isEnabled("arboriculture")) {
            ItemGroups.tabArboriculture = new ItemGroupForestry(3, "arboriculture");
        }
        if (ModuleHelper.isEnabled("lepidopterology")) {
            ItemGroups.tabLepidopterology = new ItemGroupForestry(4, "lepidopterology");
        }
        tabForestry = new ItemGroupForestry(0, "forestry");
    }
}

