/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import forestry.api.circuits.ChipsetManager;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.api.modules.ForestryModule;
import forestry.api.multiblock.MultiblockManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.IPickupHandler;
import forestry.core.ISaveEventHandler;
import forestry.core.PickupHandlerCore;
import forestry.core.SaveEventHandlerCore;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.GuiSolderingIron;
import forestry.core.circuits.SolderManager;
import forestry.core.commands.CommandModules;
import forestry.core.config.Config;
import forestry.core.features.CoreContainers;
import forestry.core.features.CoreFeatures;
import forestry.core.genetics.alleles.AlleleFactory;
import forestry.core.gui.GuiAlyzer;
import forestry.core.gui.GuiAnalyzer;
import forestry.core.gui.GuiEscritoire;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.core.multiblock.MultiblockLogicFactory;
import forestry.core.network.IPacketRegistry;
import forestry.core.network.PacketRegistryCore;
import forestry.core.owner.GameProfileDataSerializer;
import forestry.core.particles.CoreParticles;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.HygroregulatorManager;
import forestry.core.utils.ClimateUtil;
import forestry.core.utils.ForestryModEnvWarningCallable;
import forestry.modules.BlankForestryModule;
import forestry.modules.ISidedModuleHandler;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@ForestryModule(containerID="forestry", moduleID="core", name="Core", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.core.description", coreModule=true)
public class ModuleCore
extends BlankForestryModule {
    public static final LiteralArgumentBuilder<CommandSource> rootCommand = LiteralArgumentBuilder.literal((String)"forestry");

    public ModuleCore() {
        CoreParticles.PARTICLE_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    @Override
    public Set<ResourceLocation> getDependencyUids() {
        return Collections.emptySet();
    }

    @Override
    public void setupAPI() {
        ChipsetManager.solderManager = new SolderManager();
        ChipsetManager.circuitRegistry = new CircuitRegistry();
        AlleleManager.climateHelper = new ClimateUtil();
        AlleleManager.alleleFactory = new AlleleFactory();
        MultiblockManager.logicFactory = new MultiblockLogicFactory();
        RecipeManagers.hygroregulatorManager = new HygroregulatorManager();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerGuiFactories() {
        ScreenManager.func_216911_a(CoreContainers.ALYZER.containerType(), GuiAlyzer::new);
        ScreenManager.func_216911_a(CoreContainers.ANALYZER.containerType(), GuiAnalyzer::new);
        ScreenManager.func_216911_a(CoreContainers.NATURALIST_INVENTORY.containerType(), GuiNaturalistInventory::new);
        ScreenManager.func_216911_a(CoreContainers.ESCRITOIRE.containerType(), GuiEscritoire::new);
        ScreenManager.func_216911_a(CoreContainers.SOLDERING_IRON.containerType(), GuiSolderingIron::new);
    }

    @Override
    public void preInit() {
        GameProfileDataSerializer.register();
        rootCommand.then(CommandModules.register());
    }

    @Override
    @Nullable
    public LiteralArgumentBuilder<CommandSource> register() {
        return rootCommand;
    }

    @Override
    public void doInit() {
        ForestryModEnvWarningCallable.register();
        Proxies.render.initRendering();
        CoreFeatures.registerOres();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerCore();
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryCore();
    }

    @Override
    public boolean processIMCMessage(InterModComms.IMCMessage message) {
        if (message.getMethod().equals("blacklist-ores-dimension")) {
            ResourceLocation[] dims;
            for (ResourceLocation dim : dims = (ResourceLocation[])message.getMessageSupplier().get()) {
                Config.blacklistOreDim(dim);
            }
            return true;
        }
        return false;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerCore();
    }

    @Override
    public ISidedModuleHandler getModuleHandler() {
        return Proxies.render;
    }
}

