/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.api.modules.ForestryModule;
import forestry.core.fluids.ForestryFluids;
import forestry.core.utils.ForgeUtils;
import forestry.modules.BlankForestryModule;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;

@ForestryModule(containerID="forestry", moduleID="fluids", name="Fluids", author="mezz", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.fluids.description")
public class ModuleFluids
extends BlankForestryModule {
    @Override
    public boolean canBeDisabled() {
        return false;
    }

    @Override
    public void preInit() {
        ForgeUtils.registerSubscriber(this);
    }

    @Override
    public void doInit() {
        FluidStack biomass;
        FluidStack ethanol = ForestryFluids.BIO_ETHANOL.getFluid(1);
        if (!ethanol.isEmpty()) {
            GeneratorFuel ethanolFuel = new GeneratorFuel(ethanol, 32, 4);
            FuelManager.generatorFuel.put(ethanol.getFluid(), ethanolFuel);
        }
        if (!(biomass = ForestryFluids.BIOMASS.getFluid(1)).isEmpty()) {
            GeneratorFuel biomassFuel = new GeneratorFuel(biomass, 8, 1);
            FuelManager.generatorFuel.put(biomass.getFluid(), biomassFuel);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void handleTextureStitchPre(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_() != PlayerContainer.field_226615_c_) {
            return;
        }
        for (ForestryFluids fluid : ForestryFluids.values()) {
            for (ResourceLocation resource : fluid.getFeature().properties().resources) {
                event.addSprite(resource);
            }
        }
    }
}

