/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import com.google.common.base.Preconditions;
import forestry.core.blocks.IBlockType;
import forestry.core.blocks.IMachinePropertiesTesr;
import forestry.core.blocks.IShapeProvider;
import forestry.core.blocks.MachineProperties;
import forestry.core.proxy.Proxies;
import forestry.core.render.IForestryRenderer;
import forestry.core.render.RenderForestryTile;
import forestry.core.tiles.TileForestry;
import forestry.modules.features.FeatureTileType;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class MachinePropertiesTesr<T extends TileForestry>
extends MachineProperties<T>
implements IMachinePropertiesTesr<T> {
    private final ResourceLocation particleTexture;
    private final boolean isFullCube;
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    private IForestryRenderer<? super T> renderer;

    public MachinePropertiesTesr(Supplier<FeatureTileType<? extends T>> teType, String name, IShapeProvider shape, ResourceLocation particleTexture, boolean isFullCube) {
        super(teType, name, shape);
        this.particleTexture = particleTexture;
        this.isFullCube = isFullCube;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRenderer(IForestryRenderer<? super T> renderer) {
        this.renderer = renderer;
    }

    @Override
    @Nullable
    public IForestryRenderer<? super T> getRenderer() {
        return this.renderer;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        if (this.renderer != null) {
            ClientRegistry.bindTileEntityRenderer(this.getTeType(), dispatcher -> new RenderForestryTile<T>((TileEntityRendererDispatcher)dispatcher, this.renderer));
        }
    }

    @Override
    public ResourceLocation getParticleTexture() {
        return this.particleTexture;
    }

    public boolean isFullCube(BlockState state) {
        return this.isFullCube;
    }

    public static Item.Properties setRenderer(Item.Properties properties, IBlockType type) {
        Proxies.render.setRenderer(properties, type);
        return properties;
    }

    public static class Builder<T extends TileForestry>
    extends MachineProperties.Builder<T, Builder<T>> {
        @Nullable
        private ResourceLocation particleTexture;
        private boolean isFullCube = true;

        public Builder(Supplier<FeatureTileType<? extends T>> type, String name) {
            super(type, name);
        }

        public Builder() {
        }

        public Builder<T> setParticleTexture(String particleTexture) {
            return this.setParticleTexture(new ResourceLocation("forestry", "block/" + particleTexture));
        }

        public Builder<T> setParticleTexture(ResourceLocation particleTexture) {
            this.particleTexture = particleTexture;
            return this;
        }

        public Builder<T> setNotFullCube() {
            this.isFullCube = false;
            return this;
        }

        @Override
        public MachinePropertiesTesr<T> create() {
            Preconditions.checkNotNull((Object)this.type);
            Preconditions.checkNotNull((Object)this.name);
            Preconditions.checkNotNull((Object)this.shape);
            Preconditions.checkNotNull((Object)this.particleTexture);
            return new MachinePropertiesTesr(this.type, this.name, this.shape, this.particleTexture, this.isFullCube);
        }
    }
}

