/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.recipes.ISolderRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CircuitRecipe
implements ISolderRecipe {
    private final ResourceLocation id;
    private final ICircuitLayout layout;
    private final ItemStack resource;
    private final ICircuit circuit;

    public CircuitRecipe(ResourceLocation id, ICircuitLayout layout, ItemStack resource, ICircuit circuit) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)layout, (Object)"Recipe layout cannot be null");
        Preconditions.checkNotNull((Object)resource, (Object)"Recipe resource cannot be null");
        Preconditions.checkNotNull((Object)circuit, (Object)"Recipe circuit cannot be null");
        this.id = id;
        this.resource = resource;
        this.layout = layout;
        this.circuit = circuit;
    }

    @Override
    public boolean matches(ICircuitLayout layout, ItemStack itemstack) {
        if (!this.layout.getUID().equals(layout.getUID())) {
            return false;
        }
        return itemstack.func_77969_a(this.resource);
    }

    @Override
    public ICircuitLayout getLayout() {
        return this.layout;
    }

    @Override
    public ItemStack getResource() {
        return this.resource;
    }

    @Override
    public ICircuit getCircuit() {
        return this.circuit;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CircuitRecipe> {
        public CircuitRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout(JSONUtils.func_151200_h((JsonObject)json, (String)"layout"));
            ICircuit circuit = ChipsetManager.circuitRegistry.getCircuit(JSONUtils.func_151200_h((JsonObject)json, (String)"circuit"));
            ItemStack resource = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"resource"));
            return new CircuitRecipe(recipeId, layout, resource, circuit);
        }

        public CircuitRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout(buffer.func_218666_n());
            ICircuit circuit = ChipsetManager.circuitRegistry.getCircuit(buffer.func_218666_n());
            ItemStack resource = buffer.func_150791_c();
            return new CircuitRecipe(recipeId, layout, resource, circuit);
        }

        public void toNetwork(PacketBuffer buffer, CircuitRecipe recipe) {
            buffer.func_180714_a(recipe.layout.getUID());
            buffer.func_180714_a(recipe.circuit.getUID());
            buffer.func_150788_a(recipe.resource);
        }
    }
}

