/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ICircuitLibrary;
import forestry.api.circuits.ICircuitRegistry;
import forestry.core.circuits.CircuitBoard;
import forestry.core.circuits.CircuitLayout;
import forestry.core.circuits.CircuitLibrary;
import forestry.core.features.CoreItems;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.server.ServerWorld;

public class CircuitRegistry
implements ICircuitRegistry {
    public static final ICircuitLayout DUMMY_LAYOUT = new CircuitLayout("dummy", CircuitSocketType.NONE);
    private static final Map<String, ICircuitLayout> DUMMY_MAP = new LinkedHashMap<String, ICircuitLayout>();
    private final Map<String, ICircuit> deprecatedCircuits = new LinkedHashMap<String, ICircuit>();
    private final Map<String, ICircuitLayout> layoutMap = new LinkedHashMap<String, ICircuitLayout>();
    private final Map<String, ICircuit> circuitMap = new LinkedHashMap<String, ICircuit>();

    @Override
    public ICircuitLibrary getCircuitLibrary(ServerWorld world, String playerName) {
        return (ICircuitLibrary)world.func_217481_x().func_215752_a(() -> new CircuitLibrary(playerName), "CircuitLibrary_" + playerName);
    }

    @Override
    public ICircuitLayout getDefaultLayout() {
        if (this.layoutMap.containsKey("forestry.engine.tin")) {
            return this.layoutMap.get("forestry.engine.tin");
        }
        if (!this.layoutMap.isEmpty()) {
            return this.layoutMap.values().iterator().next();
        }
        return DUMMY_LAYOUT;
    }

    @Override
    public Map<String, ICircuitLayout> getRegisteredLayouts() {
        if (this.layoutMap.isEmpty()) {
            return DUMMY_MAP;
        }
        return this.layoutMap;
    }

    @Override
    public void registerLayout(ICircuitLayout layout) {
        this.layoutMap.put(layout.getUID(), layout);
    }

    @Override
    public void registerDeprecatedCircuitReplacement(String deprecatedCircuit, ICircuit replacement) {
        this.deprecatedCircuits.put(deprecatedCircuit, replacement);
    }

    @Override
    @Nullable
    public ICircuitLayout getLayout(String uid) {
        return this.layoutMap.getOrDefault(uid, null);
    }

    @Override
    public Map<String, ICircuit> getRegisteredCircuits() {
        return this.circuitMap;
    }

    @Override
    public void registerCircuit(ICircuit circuit) {
        this.circuitMap.put(circuit.getUID(), circuit);
    }

    @Override
    @Nullable
    public ICircuit getCircuit(String uid) {
        if (this.deprecatedCircuits.containsKey(uid)) {
            return this.deprecatedCircuits.get(uid);
        }
        return this.circuitMap.get(uid);
    }

    @Override
    public boolean isChipset(ItemStack itemstack) {
        return CoreItems.CIRCUITBOARDS.itemEqual(itemstack);
    }

    @Override
    public ICircuitBoard getCircuitBoard(ItemStack itemstack) {
        CompoundNBT compoundNBT = itemstack.func_77978_p();
        if (compoundNBT == null) {
            return null;
        }
        return new CircuitBoard(compoundNBT);
    }

    static {
        DUMMY_MAP.put("dummy", DUMMY_LAYOUT);
    }
}

