/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ICircuitLayout;
import forestry.core.features.CoreContainers;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotFiltered;
import forestry.core.gui.slots.SlotOutput;
import forestry.core.inventory.ItemInventorySolderingIron;
import forestry.core.network.packets.PacketGuiLayoutSelect;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.utils.NetworkUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerSolderingIron
extends ContainerItemInventory<ItemInventorySolderingIron>
implements IGuiSelectable {
    public static ContainerSolderingIron fromNetwork(int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        Hand hand = extraData.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND;
        PlayerEntity player = playerInv.field_70458_d;
        ItemInventorySolderingIron inv = new ItemInventorySolderingIron(player, player.func_184586_b(hand));
        return new ContainerSolderingIron(windowId, player, inv);
    }

    public ContainerSolderingIron(int windowId, PlayerEntity player, ItemInventorySolderingIron inventory) {
        super(windowId, inventory, player.field_71071_by, 8, 123, CoreContainers.SOLDERING_IRON.containerType());
        this.func_75146_a(new SlotFiltered(inventory, 0, 152, 12));
        this.func_75146_a(new SlotOutput(inventory, 1, 152, 92));
        this.func_75146_a(new SlotFiltered(inventory, 2, 12, 32));
        this.func_75146_a(new SlotFiltered(inventory, 3, 12, 52));
        this.func_75146_a(new SlotFiltered(inventory, 4, 12, 72));
        this.func_75146_a(new SlotFiltered(inventory, 5, 12, 92));
    }

    public ICircuitLayout getLayout() {
        return ((ItemInventorySolderingIron)this.inventory).getLayout();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void advanceSelection(int index) {
        ContainerSolderingIron.sendSelectionChange(index, 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void regressSelection(int index) {
        ContainerSolderingIron.sendSelectionChange(index, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sendSelectionChange(int index, int advance) {
        PacketGuiSelectRequest packet = new PacketGuiSelectRequest(index, advance);
        NetworkUtil.sendToServer(packet);
    }

    @Override
    public void handleSelectionRequest(ServerPlayerEntity player, int primary, int secondary) {
        if (secondary == 0) {
            if (primary == 0) {
                ((ItemInventorySolderingIron)this.inventory).advanceLayout();
            }
        } else if (primary == 0) {
            ((ItemInventorySolderingIron)this.inventory).regressLayout();
        }
        PacketGuiLayoutSelect packetResponse = new PacketGuiLayoutSelect(((ItemInventorySolderingIron)this.inventory).getLayout().getUID());
        NetworkUtil.sendToPlayer(packetResponse, (PlayerEntity)player);
    }

    public void setLayout(ICircuitLayout layout) {
        ((ItemInventorySolderingIron)this.inventory).setLayout(layout);
    }
}

