/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ICircuitSocketType;
import forestry.api.farming.FarmDirection;
import forestry.api.recipes.ISolderRecipe;
import forestry.core.circuits.ContainerSolderingIron;
import forestry.core.gui.GuiForestry;
import forestry.core.inventory.ItemInventorySolderingIron;
import forestry.core.render.ColourProperties;
import forestry.core.utils.ClientUtils;
import forestry.core.utils.Translator;
import java.util.Locale;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiSolderingIron
extends GuiForestry<ContainerSolderingIron> {
    private final ItemInventorySolderingIron itemInventory;

    public GuiSolderingIron(ContainerSolderingIron container, PlayerInventory inv, ITextComponent title) {
        super("textures/gui/solder.png", container, inv, title);
        this.itemInventory = (ItemInventorySolderingIron)container.getItemInventory();
        this.field_146999_f = 176;
        this.field_147000_g = 205;
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int mouseY, int mouseX) {
        super.func_230450_a_(transform, partialTicks, mouseY, mouseX);
        ICircuitLayout layout = ((ContainerSolderingIron)this.container).getLayout();
        String title = layout.getName();
        this.getFontRenderer().func_238421_b_(transform, title, (float)(this.field_147003_i + 8 + this.textLayout.getCenteredOffset(title, 138)), (float)(this.field_147009_r + 16), ColourProperties.INSTANCE.get("gui.screen"));
        for (int i = 0; i < 4; ++i) {
            ICircuitSocketType socketType;
            ItemStack tube = this.itemInventory.func_70301_a(i + 2);
            ISolderRecipe recipe = ChipsetManager.solderManager.getMatchingRecipe(ClientUtils.getRecipeManager(), layout, tube);
            String description = recipe == null ? "(" + Translator.translateToLocal("for.gui.noeffect") + ")" : recipe.getCircuit().getDisplayName().getString();
            int row = i * 20;
            this.getFontRenderer().func_238421_b_(transform, description, (float)(this.field_147003_i + 32), (float)(this.field_147009_r + 36 + row), ColourProperties.INSTANCE.get("gui.screen"));
            if (!tube.func_190926_b() || !CircuitSocketType.FARM.equals(socketType = layout.getSocketType())) continue;
            FarmDirection farmDirection = FarmDirection.values()[i];
            String farmDirectionString = farmDirection.toString().toLowerCase(Locale.ENGLISH);
            String localizedDirection = Translator.translateToLocal("for.gui.solder." + farmDirectionString);
            this.getFontRenderer().func_238421_b_(transform, localizedDirection, (float)(this.field_147003_i + 17), (float)(this.field_147009_r + 36 + row), ColourProperties.INSTANCE.get("gui.screen"));
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 12, this.field_147009_r + 10, 12, 18, (ITextComponent)new StringTextComponent("<"), b -> ContainerSolderingIron.regressSelection(0)));
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 130, this.field_147009_r + 10, 12, 18, (ITextComponent)new StringTextComponent(">"), b -> ContainerSolderingIron.advanceSelection(0)));
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.itemInventory);
        this.addHintLedger("soldering.iron");
    }
}

