/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.core.circuits.CircuitBoard;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.features.CoreItems;
import forestry.core.items.ItemForestry;
import forestry.core.items.definitions.IColoredItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCircuitBoard
extends ItemForestry
implements IColoredItem {
    private final EnumCircuitBoardType type;

    public ItemCircuitBoard(EnumCircuitBoardType type) {
        this.type = type;
    }

    public EnumCircuitBoardType getType() {
        return this.type;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)ItemCircuitBoard.createCircuitboard(this.type, null, new ICircuit[0]));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColorFromItemStack(ItemStack itemstack, int tintIndex) {
        if (tintIndex == 0) {
            return this.type.getPrimaryColor();
        }
        return this.type.getSecondaryColor();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        ICircuitBoard circuitboard = ChipsetManager.circuitRegistry.getCircuitBoard(itemstack);
        if (circuitboard != null) {
            circuitboard.addTooltip(list);
        }
    }

    public static ItemStack createCircuitboard(EnumCircuitBoardType type, @Nullable ICircuitLayout layout, ICircuit[] circuits) {
        CompoundNBT compoundNBT = new CompoundNBT();
        new CircuitBoard(type, layout, circuits).write(compoundNBT);
        ItemStack stack = CoreItems.CIRCUITBOARDS.stack(type, 1);
        stack.func_77982_d(compoundNBT);
        return stack;
    }

    public ItemStack get(EnumCircuitBoardType type) {
        return CoreItems.CIRCUITBOARDS.stack(type, 1);
    }
}

