/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import com.google.common.base.Preconditions;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.recipes.IForestryRecipe;
import forestry.api.recipes.ISolderManager;
import forestry.api.recipes.ISolderRecipe;
import forestry.core.circuits.CircuitRecipe;
import forestry.factory.recipes.AbstractCraftingProvider;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;

public class SolderManager
extends AbstractCraftingProvider<ISolderRecipe>
implements ISolderManager {
    public SolderManager() {
        super(ISolderRecipe.TYPE);
    }

    @Override
    public void addRecipe(ICircuitLayout layout, ItemStack resource, ICircuit circuit) {
        Preconditions.checkNotNull((Object)layout, (Object)"layout may not be null");
        Preconditions.checkNotNull((Object)resource, (Object)"resource may not be null");
        Preconditions.checkNotNull((Object)circuit, (Object)"circuit may not be null");
        this.addRecipe(new CircuitRecipe(IForestryRecipe.anonymous(), layout, resource, circuit));
    }

    @Override
    @Nullable
    public ICircuit getCircuit(@Nullable RecipeManager recipeManager, ICircuitLayout layout, ItemStack resource) {
        ISolderRecipe circuitRecipe = this.getMatchingRecipe(recipeManager, layout, resource);
        if (circuitRecipe == null) {
            return null;
        }
        return circuitRecipe.getCircuit();
    }

    @Override
    @Nullable
    public ISolderRecipe getMatchingRecipe(@Nullable RecipeManager recipeManager, @Nullable ICircuitLayout layout, ItemStack resource) {
        if (layout != null) {
            for (ISolderRecipe recipe : this.getRecipes(recipeManager)) {
                if (!recipe.matches(layout, resource)) continue;
                return recipe;
            }
        }
        return null;
    }
}

