/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.ClimateManager;
import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateHousing;
import forestry.api.climate.IClimateManipulatorBuilder;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.api.climate.IWorldClimateHolder;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.climate.AbsentClimateState;
import forestry.core.climate.ClimateManipulator;
import forestry.core.climate.ClimateRoot;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.config.Config;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ClimateTransformer
implements IClimateTransformer,
IStreamable,
INbtReadable,
INbtWritable {
    private static final String CURRENT_STATE_KEY = "Current";
    private static final String STATE_KEY = "State";
    private static final String TARGETED_STATE_KEY = "Target";
    private static final String CIRCULAR_KEY = "Circular";
    private static final String RANGE_KEY = "Range";
    protected final IClimateHousing housing;
    private IClimateState targetedState;
    private IClimateState currentState;
    private IClimateState defaultState;
    private int range;
    private int area;
    private boolean addedToWorld;
    private boolean circular;

    public ClimateTransformer(IClimateHousing housing) {
        this.housing = housing;
        this.currentState = ClimateStateHelper.INSTANCE.absent();
        this.defaultState = AbsentClimateState.INSTANCE;
        this.targetedState = AbsentClimateState.INSTANCE;
        this.setRange(Config.habitatformerRange);
        this.circular = true;
        this.addedToWorld = false;
    }

    @Override
    public IClimateHousing getHousing() {
        return this.housing;
    }

    @Override
    public void update() {
        if (!this.addedToWorld) {
            World world = this.housing.getWorldObj();
            BlockPos pos = this.housing.getCoordinates();
            this.defaultState = ClimateRoot.getInstance().getBiomeState(world, pos);
            if (!this.targetedState.isPresent()) {
                this.setCurrent(this.defaultState.copy());
                this.setTarget(this.defaultState);
            }
            IWorldClimateHolder worldClimate = ClimateManager.climateRoot.getWorldClimate(world);
            worldClimate.updateTransformer(this);
            this.addedToWorld = true;
        }
    }

    @Override
    public void removeTransformer() {
        this.addedToWorld = false;
        IWorldClimateHolder worldClimate = ClimateManager.climateRoot.getWorldClimate(this.housing.getWorldObj());
        worldClimate.removeTransformer(this);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_218657_a(CURRENT_STATE_KEY, (INBT)ClimateStateHelper.INSTANCE.writeToNBT(new CompoundNBT(), this.currentState));
        nbt.func_218657_a(TARGETED_STATE_KEY, (INBT)ClimateStateHelper.INSTANCE.writeToNBT(new CompoundNBT(), this.targetedState));
        nbt.func_74757_a(CIRCULAR_KEY, this.circular);
        nbt.func_74768_a(RANGE_KEY, this.range);
        return nbt;
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.currentState = ClimateManager.stateHelper.create(nbt.func_74775_l(CURRENT_STATE_KEY));
        this.targetedState = ClimateManager.stateHelper.create(nbt.func_74775_l(TARGETED_STATE_KEY));
        this.circular = nbt.func_74767_n(CIRCULAR_KEY);
        this.range = nbt.func_74762_e(RANGE_KEY);
        this.onAreaChange(this.range, this.circular);
    }

    @Override
    public IClimateManipulatorBuilder createManipulator(ClimateType type) {
        return new ClimateManipulator.Builder().setDefault(this.defaultState).setCurrent(this.currentState).setTarget(this.targetedState).setChangeSupplier(this.housing::getChangeForState).setType(type).setOnFinish(this::setCurrent);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeClimateState(this.currentState);
        data.writeClimateState(this.targetedState);
        data.writeClimateState(this.defaultState);
        data.writeBoolean(this.circular);
        data.func_150787_b(this.range);
        this.onAreaChange(this.range, this.circular);
    }

    @Override
    public void readData(PacketBufferForestry data) {
        this.currentState = data.readClimateState();
        this.targetedState = data.readClimateState();
        this.defaultState = data.readClimateState();
        this.circular = data.readBoolean();
        this.range = data.func_150792_a();
    }

    @Override
    public IClimateState getCurrent() {
        return this.currentState;
    }

    @Override
    public void setCurrent(IClimateState state) {
        if (!(state = ClimateStateHelper.INSTANCE.clamp(state.toImmutable())).equals(this.currentState)) {
            this.currentState = state;
            this.housing.markNetworkUpdate();
            if (this.addedToWorld) {
                IWorldClimateHolder worldClimate = ClimateManager.climateRoot.getWorldClimate(this.getWorldObj());
                worldClimate.updateTransformer(this);
            }
        }
    }

    @Override
    public IClimateState getTarget() {
        return this.targetedState;
    }

    @Override
    public void setTarget(IClimateState target) {
        this.targetedState = ClimateStateHelper.INSTANCE.clamp(target.toImmutable());
        this.housing.markNetworkUpdate();
    }

    @Override
    public IClimateState getDefault() {
        return this.defaultState;
    }

    @Override
    public void setCircular(boolean value) {
        if (this.circular != value) {
            this.circular = value;
            this.onAreaChange(this.range, !value);
            this.housing.markNetworkUpdate();
            if (this.addedToWorld) {
                IWorldClimateHolder worldClimate = ClimateManager.climateRoot.getWorldClimate(this.getWorldObj());
                worldClimate.updateTransformer(this);
            }
        }
    }

    @Override
    public boolean isCircular() {
        return this.circular;
    }

    @Override
    public void setRange(int value) {
        if (value != this.range) {
            int oldRange = this.range;
            this.range = MathHelper.func_76125_a((int)value, (int)1, (int)16);
            this.onAreaChange(oldRange, this.circular);
            this.housing.markNetworkUpdate();
            if (this.addedToWorld) {
                IWorldClimateHolder worldClimate = ClimateManager.climateRoot.getWorldClimate(this.getWorldObj());
                worldClimate.updateTransformer(this);
            }
        }
    }

    private void onAreaChange(int range, boolean circular) {
        int prevArea = this.area;
        this.area = ClimateTransformer.computeArea(range, circular);
        if (this.addedToWorld && this.area != prevArea) {
            int areaDelta = Math.abs(this.area - prevArea);
            float speedDelta = ClimateTransformer.calculateSpeedModifier(areaDelta);
            IClimateState deltaState = this.currentState.subtract(this.defaultState);
            IClimateState scaledDelta = deltaState.multiply(this.area > prevArea ? (double)(1.0f / speedDelta) : (double)speedDelta);
            this.setCurrent(scaledDelta.add(this.defaultState));
        }
    }

    private static int computeArea(int range, boolean circular) {
        return circular ? Math.round(((float)range + 0.5f) * ((float)range + 0.5f) * 2.0f * (float)Math.PI) : (range * 2 + 1) * (range * 2 + 1);
    }

    @Override
    public float getAreaModifier() {
        return ClimateTransformer.calculateAreaModifier(this.area);
    }

    @Override
    public float getCostModifier() {
        return 1.0f + this.getAreaModifier() * Config.habitatformerAreaCostModifier;
    }

    @Override
    public float getSpeedModifier() {
        return ClimateTransformer.calculateSpeedModifier(this.area);
    }

    private static float calculateSpeedModifier(float area) {
        return 1.0f + ClimateTransformer.calculateAreaModifier(area) * Config.habitatformerAreaSpeedModifier;
    }

    private static float calculateAreaModifier(float area) {
        return area / 36.0f;
    }

    @Override
    public int getArea() {
        return this.area;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public BlockPos getCoordinates() {
        return this.housing.getCoordinates();
    }

    @Override
    public World getWorldObj() {
        return this.housing.getWorldObj();
    }
}

