/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import com.google.common.base.MoreObjects;
import forestry.api.climate.IClimateState;
import forestry.core.climate.ClimateStateHelper;
import java.util.function.UnaryOperator;

class ImmutableClimateState
implements IClimateState {
    static final ImmutableClimateState MIN = new ImmutableClimateState(0.0f, 0.0f);
    static final ImmutableClimateState MAX = new ImmutableClimateState(2.0f, 2.0f);
    private final float temperature;
    private final float humidity;

    ImmutableClimateState(IClimateState climateState) {
        this(climateState.getTemperature(), climateState.getHumidity());
    }

    ImmutableClimateState(float temperature, float humidity) {
        this.temperature = temperature;
        this.humidity = humidity;
    }

    @Override
    public IClimateState copy(boolean mutable) {
        return ClimateStateHelper.INSTANCE.create(this, mutable);
    }

    @Override
    public IClimateState copy() {
        return this;
    }

    @Override
    public IClimateState toMutable() {
        return this.copy(true);
    }

    @Override
    public IClimateState toImmutable() {
        return this;
    }

    @Override
    public IClimateState addTemperature(float temperature) {
        return ClimateStateHelper.of(this.temperature + temperature, this.humidity);
    }

    @Override
    public IClimateState addHumidity(float humidity) {
        return ClimateStateHelper.of(this.temperature, this.humidity + humidity);
    }

    @Override
    public IClimateState add(IClimateState state) {
        return ClimateStateHelper.of(this.temperature + state.getTemperature(), this.humidity + state.getHumidity());
    }

    @Override
    public IClimateState setTemperature(float temperature) {
        return ClimateStateHelper.of(temperature, this.humidity);
    }

    @Override
    public IClimateState setHumidity(float humidity) {
        return ClimateStateHelper.of(this.temperature, humidity);
    }

    @Override
    public IClimateState setClimate(float temperature, float humidity) {
        return ClimateStateHelper.of(temperature, humidity);
    }

    @Override
    public IClimateState multiply(double factor) {
        return ClimateStateHelper.of((float)((double)this.temperature * factor), (float)((double)this.humidity * factor));
    }

    @Override
    public IClimateState subtract(IClimateState state) {
        return ClimateStateHelper.of(this.temperature - state.getTemperature(), this.humidity - state.getHumidity());
    }

    @Override
    public IClimateState map(UnaryOperator<Float> mapper) {
        return ClimateStateHelper.of(((Float)mapper.apply(Float.valueOf(this.temperature))).floatValue(), ((Float)mapper.apply(Float.valueOf(this.humidity))).floatValue());
    }

    @Override
    public boolean isPresent() {
        return !Float.isNaN(this.temperature) && !Float.isNaN(this.humidity);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isClamped() {
        return this.temperature < 2.0f && this.temperature >= 0.0f && this.humidity < 2.0f && this.humidity >= 0.0f;
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public float getHumidity() {
        return this.humidity;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IClimateState)) {
            return false;
        }
        IClimateState otherState = (IClimateState)obj;
        return otherState.getTemperature() == this.temperature && otherState.getHumidity() == this.humidity;
    }

    public int hashCode() {
        return Float.hashCode(this.temperature) * 31 + Float.hashCode(this.humidity);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("temperature", this.temperature).add("humidity", this.humidity).toString();
    }
}

