/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import com.google.common.base.MoreObjects;
import forestry.api.climate.IClimateState;
import forestry.core.climate.ClimateStateHelper;
import java.util.function.UnaryOperator;

class MutableClimateState
implements IClimateState {
    protected float temperature;
    protected float humidity;
    protected float clamp;

    MutableClimateState(IClimateState climateState) {
        this(climateState.getTemperature(), climateState.getHumidity());
    }

    MutableClimateState(float temperature, float humidity) {
        this.temperature = temperature;
        this.humidity = humidity;
    }

    @Override
    public IClimateState copy(boolean mutable) {
        return ClimateStateHelper.INSTANCE.create(this, mutable);
    }

    @Override
    public IClimateState copy() {
        return this.copy(true);
    }

    @Override
    public IClimateState toMutable() {
        return this;
    }

    @Override
    public IClimateState toImmutable() {
        return this.copy(false);
    }

    @Override
    public IClimateState setTemperature(float temperature) {
        this.temperature = temperature;
        return ClimateStateHelper.INSTANCE.checkState(this);
    }

    @Override
    public IClimateState setHumidity(float humidity) {
        this.humidity = humidity;
        return ClimateStateHelper.INSTANCE.checkState(this);
    }

    @Override
    public IClimateState setClimate(float temperature, float humidity) {
        this.temperature = temperature;
        this.humidity = humidity;
        return ClimateStateHelper.INSTANCE.checkState(this);
    }

    @Override
    public IClimateState addTemperature(float temperature) {
        this.temperature += temperature;
        return ClimateStateHelper.INSTANCE.checkState(this);
    }

    @Override
    public IClimateState addHumidity(float humidity) {
        this.humidity += humidity;
        return ClimateStateHelper.INSTANCE.checkState(this);
    }

    @Override
    public IClimateState add(IClimateState state) {
        this.humidity += state.getHumidity();
        this.temperature += state.getTemperature();
        return ClimateStateHelper.INSTANCE.checkState(this);
    }

    @Override
    public IClimateState multiply(double factor) {
        this.humidity = (float)((double)this.humidity * factor);
        this.temperature = (float)((double)this.temperature * factor);
        return ClimateStateHelper.INSTANCE.checkState(this);
    }

    @Override
    public IClimateState subtract(IClimateState state) {
        this.humidity -= state.getHumidity();
        this.temperature -= state.getTemperature();
        return ClimateStateHelper.INSTANCE.checkState(this);
    }

    @Override
    public IClimateState map(UnaryOperator<Float> mapper) {
        this.temperature = ((Float)mapper.apply(Float.valueOf(this.temperature))).floatValue();
        this.humidity = ((Float)mapper.apply(Float.valueOf(this.humidity))).floatValue();
        return this;
    }

    @Override
    public boolean isPresent() {
        return !Float.isNaN(this.temperature) && !Float.isNaN(this.humidity);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isClamped() {
        return this.temperature < 2.0f && this.temperature >= 0.0f && this.humidity < 2.0f && this.humidity >= 0.0f;
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public float getHumidity() {
        return this.humidity;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IClimateState)) {
            return false;
        }
        IClimateState otherState = (IClimateState)obj;
        return otherState.getTemperature() == this.temperature && otherState.getHumidity() == this.humidity;
    }

    public int hashCode() {
        return Float.hashCode(this.temperature) * 31 + Float.hashCode(this.humidity);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("temperature", this.temperature).add("humidity", this.humidity).toString();
    }
}

