/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import forestry.core.commands.ICommandModeHelper;
import genetics.commands.CommandHelpers;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class CommandModeInfo
implements Command<CommandSource> {
    private final ICommandModeHelper modeHelper;

    public CommandModeInfo(ICommandModeHelper modeHelper) {
        this.modeHelper = modeHelper;
    }

    public static ArgumentBuilder<CommandSource, ?> register(ICommandModeHelper modeHelper) {
        return Commands.func_197057_a((String)"info").then(Commands.func_197056_a((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Stream.of(modeHelper.getModeNames()).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes((Command)new CommandModeInfo(modeHelper)));
    }

    public int run(CommandContext<CommandSource> ctxContext) {
        String modeName = (String)ctxContext.getArgument("mode", String.class);
        Style green = Style.field_240709_b_;
        green.func_240712_a_(TextFormatting.GREEN);
        CommandHelpers.sendLocalizedChatMessage((CommandSource)ctxContext.getSource(), green, modeName, new Object[0]);
        for (String desc : this.modeHelper.getDescription(modeName)) {
            CommandHelpers.sendLocalizedChatMessage((CommandSource)ctxContext.getSource(), "for." + desc, new Object[0]);
        }
        return 1;
    }
}

