/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import forestry.core.commands.ICommandModeHelper;
import genetics.commands.CommandHelpers;
import genetics.commands.PermLevel;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class CommandModeSet
implements Command<CommandSource> {
    private final ICommandModeHelper modeSetter;

    public CommandModeSet(ICommandModeHelper modeSetter) {
        this.modeSetter = modeSetter;
    }

    public static ArgumentBuilder<CommandSource, ?> register(ICommandModeHelper modeHelper) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires((Predicate)PermLevel.ADMIN)).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            Stream.of(modeHelper.getModeNames()).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes((Command)new CommandModeSet(modeHelper)));
    }

    public int run(CommandContext<CommandSource> ctx) {
        String modeName;
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        if (this.modeSetter.setMode((World)world, modeName = (String)ctx.getArgument("name", String.class))) {
            CommandHelpers.sendLocalizedChatMessage((CommandSource)ctx.getSource(), "for.chat.command.forestry.mode.set.success", modeName);
            return 1;
        }
        CommandHelpers.sendLocalizedChatMessage((CommandSource)ctx.getSource(), "for.chat.command.forestry.mode.set.error", modeName);
        return 0;
    }
}

