/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.core.commands.ICommandModeHelper;
import forestry.core.commands.IStatsSaveHelper;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import genetics.api.GeneticsAPI;
import genetics.api.alleles.IAlleleSpecies;
import genetics.commands.CommandHelpers;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public final class CommandSaveStats
implements Command<CommandSource> {
    private static final String discoveredSymbol = Translator.translateToLocal("for.chat.command.forestry.stats.save.key.discovered.symbol");
    private static final String blacklistedSymbol = Translator.translateToLocal("for.chat.command.forestry.stats.save.key.blacklisted.symbol");
    private static final String notCountedSymbol = Translator.translateToLocal("for.chat.command.forestry.stats.save.key.notCounted.symbol");
    private final IStatsSaveHelper saveHelper;
    private final ICommandModeHelper modeHelper;

    public CommandSaveStats(IStatsSaveHelper saveHelper, ICommandModeHelper modeHelper) {
        this.saveHelper = saveHelper;
        this.modeHelper = modeHelper;
    }

    public static ArgumentBuilder<CommandSource, ?> register(IStatsSaveHelper saveHelper, ICommandModeHelper modeHelper) {
        return Commands.func_197057_a((String)"save").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes((Command)new CommandSaveStats(saveHelper, modeHelper)));
    }

    public int run(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        String newLine = System.getProperty("line.separator");
        ServerPlayerEntity player = EntityArgument.func_197089_d(ctx, (String)"player");
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        ArrayList<String> statistics = new ArrayList<String>();
        String date = DateFormat.getInstance().format(new Date());
        statistics.add(Translator.translateToLocalFormatted(this.saveHelper.getUnlocalizedSaveStatsString(), player.func_145748_c_(), date));
        statistics.add("");
        statistics.add(Translator.translateToLocalFormatted("for.chat.command.forestry.stats.save.mode", this.modeHelper.getModeName((World)world)));
        statistics.add("");
        IBreedingTracker tracker = this.saveHelper.getBreedingTracker((World)world, player.func_146103_bH());
        this.saveHelper.addExtraInfo(statistics, tracker);
        Collection<? extends IAlleleForestrySpecies> species = this.saveHelper.getSpecies();
        String speciesCount = Translator.translateToLocal("for.gui.speciescount");
        String speciesCountLine = String.format("%s (%s):", speciesCount, species.size());
        statistics.add(speciesCountLine);
        statistics.add(StringUtil.line(speciesCountLine.length()));
        statistics.add(discoveredSymbol + ": " + Translator.translateToLocal("for.chat.command.forestry.stats.save.key.discovered"));
        statistics.add(blacklistedSymbol + ": " + Translator.translateToLocal("for.chat.command.forestry.stats.save.key.blacklisted"));
        statistics.add(notCountedSymbol + ": " + Translator.translateToLocal("for.chat.command.forestry.stats.save.key.notCounted"));
        statistics.add("");
        String header = CommandSaveStats.generateSpeciesListHeader();
        statistics.add(header);
        statistics.add(StringUtil.line(header.length()));
        statistics.add("");
        for (IAlleleSpecies iAlleleSpecies : species) {
            statistics.add(CommandSaveStats.generateSpeciesListEntry(iAlleleSpecies, tracker));
        }
        File file = new File(Proxies.common.getForestryRoot(), "config/forestry/stats/" + player.func_145748_c_().getString() + '-' + this.saveHelper.getFileSuffix() + ".log");
        try {
            boolean success;
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists() && !(success = file.getParentFile().mkdirs())) {
                CommandHelpers.sendLocalizedChatMessage((CommandSource)ctx.getSource(), "for.chat.command.forestry.stats.save.error1", new Object[0]);
                return 0;
            }
            if (!file.exists() && !file.createNewFile()) {
                CommandHelpers.sendLocalizedChatMessage((CommandSource)ctx.getSource(), "for.chat.command.forestry.stats.save.error1", new Object[0]);
                return 0;
            }
            if (!file.canWrite()) {
                CommandHelpers.sendLocalizedChatMessage((CommandSource)ctx.getSource(), "for.chat.command.forestry.stats.save.error2", new Object[0]);
                return 0;
            }
            FileOutputStream fileout = new FileOutputStream(file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileout, StandardCharsets.UTF_8));
            writer.write("# forestry" + newLine + "# " + ((ModContainer)ModList.get().getModContainerById("forestry").get()).getModInfo().getVersion() + newLine);
            for (String line : statistics) {
                writer.write(line + newLine);
            }
            writer.close();
        }
        catch (IOException iOException) {
            CommandHelpers.sendLocalizedChatMessage((CommandSource)ctx.getSource(), "for.chat.command.forestry.stats.save.error3", new Object[0]);
            Log.error(Translator.translateToLocal("for.for.chat.command.forestry.stats.save.error3"), iOException);
            return 0;
        }
        CommandHelpers.sendLocalizedChatMessage((CommandSource)ctx.getSource(), "for.chat.command.forestry.stats.save.saved", player.func_145748_c_());
        return 1;
    }

    private static String generateSpeciesListHeader() {
        String authority = Translator.translateToLocal("for.gui.alyzer.authority");
        String species = Translator.translateToLocal("for.gui.species");
        return CommandSaveStats.speciesListEntry(discoveredSymbol, blacklistedSymbol, notCountedSymbol, "UID", species, authority);
    }

    private static String generateSpeciesListEntry(IAlleleSpecies species, IBreedingTracker tracker) {
        String discovered = "";
        if (tracker.isDiscovered(species)) {
            discovered = discoveredSymbol;
        }
        String blacklisted = "";
        if (GeneticsAPI.apiInstance.getAlleleRegistry().isBlacklisted(species.getRegistryName())) {
            blacklisted = blacklistedSymbol;
        }
        String notCounted = "";
        if (!species.isDominant()) {
            notCounted = notCountedSymbol;
        }
        return CommandSaveStats.speciesListEntry(discovered, blacklisted, notCounted, species.getRegistryName().toString(), species.getDisplayName().getString(), species.getAuthority());
    }

    private static String speciesListEntry(String discovered, String blacklisted, String notCounted, String UID, String speciesName, String authority) {
        return String.format("[ %-2s ] [ %-2s ] [ %-2s ]\t%-40s %-20s %-20s", discovered, blacklisted, notCounted, UID, speciesName, authority);
    }
}

