/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BlockStateProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Map<Block, IBuilder> blockToBuilder = Maps.newLinkedHashMap();
    protected final DataGenerator generator;

    public BlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.blockToBuilder.clear();
        this.registerStates();
        this.blockToBuilder.forEach((key, builder) -> {
            if (key.getRegistryName() == null) {
                return;
            }
            JsonObject jsonobject = builder.serialize((Block)key);
            Path path = this.makePath(key.getRegistryName());
            try {
                String s = GSON.toJson((JsonElement)jsonobject);
                String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
                if (!Objects.equals(cache.func_208323_a(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s);
                    }
                }
                cache.func_208316_a(path, s1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save models to {}", (Object)path, (Object)ioexception);
            }
        });
    }

    public abstract void registerStates();

    protected Path makePath(ResourceLocation location) {
        return this.generator.func_200391_b().resolve("assets/" + location.func_110624_b() + "/blockstates/" + location.func_110623_a() + ".json");
    }

    public void addVariants(Block block, IBuilder builder) {
        this.blockToBuilder.put(block, builder);
    }

    public String func_200397_b() {
        return "Block State Provider";
    }

    public static interface IBuilder {
        public JsonObject serialize(Block var1);
    }

    public static class PropertyValueCondition<V extends Comparable<V>>
    implements ICondition {
        private final Property<V> property;
        private final V[] values;
        private final boolean negated;

        @SafeVarargs
        public PropertyValueCondition(Property<V> property, boolean negated, V ... values) {
            this.property = property;
            this.values = values;
            this.negated = negated;
        }

        @Override
        public JsonElement serialize() {
            StringBuilder valueName = new StringBuilder();
            if (this.negated) {
                valueName.append('!');
            }
            for (int i = 0; i < this.values.length; ++i) {
                V value = this.values[i];
                if (i > 0) {
                    valueName.append('|');
                }
                valueName.append(this.property.func_177702_a(value));
            }
            return new JsonPrimitive(valueName.toString());
        }

        @Override
        public String getName() {
            return this.property.func_177701_a();
        }
    }

    public static class OrCondition
    implements ICondition {
        private final Iterable<ICondition> conditions;

        public OrCondition(Iterable<ICondition> conditions) {
            this.conditions = conditions;
        }

        @Override
        public JsonElement serialize() {
            JsonObject obj = new JsonObject();
            JsonArray conditionArray = new JsonArray();
            this.conditions.forEach(condition -> conditionArray.add(condition.serialize()));
            obj.add("OR", (JsonElement)conditionArray);
            return obj;
        }

        @Override
        public String getName() {
            return "OR";
        }
    }

    public static class AndCondition
    implements ICondition {
        private final Iterable<ICondition> conditions;
        private final boolean nested;

        public AndCondition(Iterable<ICondition> conditions, boolean nested) {
            this.conditions = conditions;
            this.nested = nested;
        }

        @Override
        public JsonElement serialize() {
            JsonObject obj = new JsonObject();
            if (this.nested) {
                JsonArray conditionArray = new JsonArray();
                this.conditions.forEach(condition -> conditionArray.add(condition.serialize()));
                obj.add("AND", (JsonElement)conditionArray);
            } else {
                this.conditions.forEach(condition -> obj.add(condition.getName(), condition.serialize()));
            }
            return obj;
        }

        @Override
        public String getName() {
            return "AND";
        }
    }

    public static interface ICondition {
        public JsonElement serialize();

        public String getName();
    }

    public static class Selector {
        @Nullable
        private final ICondition condition;
        private final List<Variant> variantList;

        public Selector(@Nullable ICondition condition, List<Variant> variantList) {
            this.condition = condition;
            this.variantList = variantList;
        }

        public JsonElement serialize() {
            JsonObject obj = new JsonObject();
            if (this.condition != null) {
                obj.add("when", this.condition.serialize());
            }
            if (this.variantList.size() > 1) {
                JsonArray variantArray = new JsonArray();
                this.variantList.forEach(variant -> variantArray.add((JsonElement)((Variant)variant).serialize()));
                obj.add("apply", (JsonElement)variantArray);
            } else {
                obj.add("apply", (JsonElement)this.variantList.get(0).serialize());
            }
            return obj;
        }
    }

    public static class ConditionBuilder {
        private final List<ICondition> conditions = new LinkedList<ICondition>();

        @SafeVarargs
        public final <V extends Comparable<V>> ConditionBuilder property(Property<V> property, V ... values) {
            this.conditions.add(new PropertyValueCondition(property, false, values));
            return this;
        }

        @SafeVarargs
        public final <V extends Comparable<V>> ConditionBuilder propertyNegated(Property<V> property, V ... values) {
            this.conditions.add(new PropertyValueCondition(property, true, values));
            return this;
        }

        public ConditionBuilder or(ConditionBuilder condition) {
            this.conditions.add(new OrCondition(condition.conditions));
            return this;
        }

        public ConditionBuilder and(ConditionBuilder condition) {
            this.conditions.add(new AndCondition(condition.conditions, true));
            return this;
        }
    }

    public static class MultipartBuilder
    implements IBuilder {
        public final List<Selector> selectors = new LinkedList<Selector>();

        public <V extends Comparable<V>> MultipartBuilder always(UnaryOperator<Variant> builder) {
            this.selectors.add(new Selector(null, Collections.singletonList(builder.apply(new Variant()))));
            return this;
        }

        @SafeVarargs
        public final <V extends Comparable<V>> MultipartBuilder property(UnaryOperator<Variant> builder, Property<V> property, V ... values) {
            return this.and(builder, new ConditionBuilder().property((Property)property, (Comparable[])values));
        }

        public MultipartBuilder or(UnaryOperator<Variant> builder, ConditionBuilder condition) {
            this.selectors.add(new Selector(new OrCondition(condition.conditions), Collections.singletonList(builder.apply(new Variant()))));
            return this;
        }

        public MultipartBuilder and(UnaryOperator<Variant> builder, ConditionBuilder condition) {
            this.selectors.add(new Selector(new AndCondition(condition.conditions, false), Collections.singletonList(builder.apply(new Variant()))));
            return this;
        }

        @Override
        public JsonObject serialize(Block block) {
            JsonObject obj = new JsonObject();
            JsonArray selectorsArray = new JsonArray();
            this.selectors.forEach(selector -> selectorsArray.add(selector.serialize()));
            obj.add("multipart", (JsonElement)selectorsArray);
            return obj;
        }
    }

    public static class Variant {
        private String model = "block/block";
        @Nullable
        private Boolean uvLock = null;
        private int weight = -1;
        private int x = -1;
        private int y = -1;

        private JsonObject serialize() {
            JsonObject obj = new JsonObject();
            obj.addProperty("model", this.model);
            if (this.uvLock != null) {
                obj.addProperty("uvlock", this.uvLock);
            }
            if (this.weight >= 0) {
                obj.addProperty("weight", (Number)this.weight);
            }
            if (this.x > 0) {
                obj.addProperty("x", (Number)this.x);
            }
            if (this.y > 0) {
                obj.addProperty("y", (Number)this.y);
            }
            return obj;
        }

        private Variant copy() {
            Variant variant = new Variant();
            variant.uvLock = this.uvLock;
            variant.model = this.model;
            variant.weight = this.weight;
            variant.x = this.x;
            variant.y = this.y;
            return variant;
        }

        public Variant model(String model) {
            this.model = model;
            return this;
        }

        public Variant lock(@Nullable Boolean uvLock) {
            this.uvLock = uvLock;
            return this;
        }

        public Variant weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Variant rotationX(int x) {
            this.x = x;
            return this;
        }

        public Variant rotationY(int y) {
            this.y = y;
            return this;
        }
    }

    public static class Builder
    implements IBuilder {
        private final List<Consumer<Variant>> always = new LinkedList<Consumer<Variant>>();
        private final Map<Predicate<BlockState>, Consumer<Variant>> variants = new HashMap<Predicate<BlockState>, Consumer<Variant>>();
        private final Multimap<BlockState, Consumer<Variant>> blockStateVariants = HashMultimap.create();
        private final Deque<List<Property<?>>> ignored = new ArrayDeque();
        private final List<Property<?>> alwaysIgnore = new LinkedList();

        public Builder push() {
            this.ignored.addFirst(new LinkedList());
            return this;
        }

        public Builder popIgnore() {
            this.ignored.pop();
            return this;
        }

        public Builder alwaysIgnore(Property<?> ... properties) {
            this.alwaysIgnore.addAll(Arrays.asList(properties));
            return this;
        }

        public <T extends Comparable<T>> Builder property(Property<T> property, T value, Consumer<Variant> consumer) {
            return this.condition(state -> state.func_177229_b(property) == value, consumer);
        }

        public <T extends Comparable<T>, V extends Comparable<V>> Builder property(Property<T> property, T value, Property<V> propertyTwo, V valueTwo, Consumer<Variant> consumer) {
            return this.condition(state -> state.func_177229_b(property) == value && state.func_177229_b(propertyTwo) == valueTwo, consumer);
        }

        public <T extends Comparable<T>> Builder state(BlockState state, Consumer<Variant> consumer) {
            Set<BlockState> mappedStates = new HashSet<BlockState>();
            mappedStates.add(state);
            LinkedList ignoredProperties = new LinkedList();
            this.ignored.forEach(ignoredProperties::addAll);
            ignoredProperties.addAll(this.alwaysIgnore);
            for (Property property : ignoredProperties) {
                mappedStates = this.mapStates(property, mappedStates);
            }
            mappedStates.forEach(mappedState -> this.blockStateVariants.put(mappedState, (Object)consumer));
            return this;
        }

        private <V extends Comparable<V>> Set<BlockState> mapStates(Property<V> property, Set<BlockState> states) {
            HashSet<BlockState> mappedStates = new HashSet<BlockState>();
            for (Comparable value : property.func_177700_c()) {
                states.forEach(mappedState -> mappedStates.add((BlockState)mappedState.func_206870_a(property, value)));
            }
            return mappedStates;
        }

        public Builder always(Consumer<Variant> consumer) {
            this.always.add(consumer);
            return this;
        }

        public Builder ignore(Property<?> property) {
            List<Property<?>> properties;
            if (this.ignored.isEmpty()) {
                properties = new LinkedList();
                this.ignored.addFirst(properties);
            } else {
                properties = this.ignored.getFirst();
            }
            properties.add(property);
            return this;
        }

        public Builder condition(Predicate<BlockState> predicate, Consumer<Variant> consumer) {
            this.variants.put(predicate, consumer);
            return this;
        }

        @Override
        public JsonObject serialize(Block block) {
            JsonObject obj = new JsonObject();
            JsonObject variantsObj = new JsonObject();
            Variant defaultVariant = new Variant();
            this.always.forEach(consumer -> consumer.accept(defaultVariant));
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                Variant variant = defaultVariant.copy();
                for (Map.Entry<Predicate<BlockState>, Consumer<Variant>> entry : this.variants.entrySet()) {
                    if (!entry.getKey().test(state)) continue;
                    entry.getValue().accept(variant);
                }
                this.blockStateVariants.get((Object)state).forEach(consumer -> consumer.accept(variant));
                HashMap properties = new HashMap(state.func_206871_b());
                this.alwaysIgnore.forEach(properties::remove);
                variantsObj.add(BlockModelShapes.func_209552_a(properties), (JsonElement)variant.serialize());
            }
            obj.add("variants", (JsonElement)variantsObj);
            return obj;
        }
    }
}

