/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.genetics.BeeDefinition;
import genetics.api.GeneticHelper;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.TickTrigger;
import net.minecraft.command.FunctionObject;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForestryAdvancementProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public ForestryAdvancementProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path outputFolder = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        this.build(advancement -> {
            if (!set.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
            }
            Path path = ForestryAdvancementProvider.createPath(outputFolder, advancement);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)path);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path, (Object)ioexception);
            }
        });
    }

    private void build(Consumer<Advancement> consumer) {
        ItemStack icon = new ItemStack((IItemProvider)ApicultureItems.BEE_QUEEN.getItem());
        GeneticHelper.setIndividual(icon, BeeDefinition.INDUSTRIOUS.createIndividual());
        Advancement.Builder.func_200278_a().func_215092_a(icon, (ITextComponent)new TranslationTextComponent("advancements.forestry.root.title"), (ITextComponent)new TranslationTextComponent("advancements.forestry.root.description"), new ResourceLocation("textures/block/honeycomb_block.png"), FrameType.TASK, false, false, false).func_200275_a("tick", (ICriterionInstance)new TickTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_)).func_200274_a(new AdvancementRewards(0, new ResourceLocation[]{new ResourceLocation("forestry", "grant_guide")}, new ResourceLocation[0], FunctionObject.CacheableFunction.field_193519_a)).func_203904_a(consumer, "forestry:root");
    }

    private static Path createPath(Path outputFolder, Advancement advancement) {
        return outputFolder.resolve("data/" + advancement.func_192067_g().func_110624_b() + "/advancements/" + advancement.func_192067_g().func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Advancements";
    }
}

