/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.Sets;
import forestry.api.core.IFeatureSubtype;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.blocks.BlockDefaultLeaves;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.arboriculture.features.CharcoalBlocks;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.loot.CountBlockFunction;
import forestry.core.blocks.EnumResourceType;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.loot.OrganismFunction;
import forestry.core.utils.Log;
import forestry.lepidopterology.features.LepidopterologyBlocks;
import forestry.modules.ModuleHelper;
import forestry.modules.ModuleManager;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureBlockGroup;
import forestry.modules.features.FeatureType;
import forestry.modules.features.IModFeature;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Items;
import net.minecraft.loot.BinomialRange;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class ForestryBlockLootTables
extends BlockLootTables {
    private final Set<Block> knownBlocks = new HashSet<Block>();

    public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        if (ModuleHelper.isEnabled("arboriculture")) {
            for (BlockDecorativeLeaves blockDecorativeLeaves : ArboricultureBlocks.LEAVES_DECORATIVE.getBlocks()) {
                this.func_218522_a(blockDecorativeLeaves, block -> ForestryBlockLootTables.droppingWithChances(block, blockDecorativeLeaves.getDefinition(), field_218579_g));
            }
            for (BlockDefaultLeaves blockDefaultLeaves : ArboricultureBlocks.LEAVES_DEFAULT.getBlocks()) {
                this.func_218522_a((Block)blockDefaultLeaves, block -> ForestryBlockLootTables.droppingWithChances(block, blockDefaultLeaves.getTreeDefinition(), field_218579_g));
            }
            for (Map.Entry entry : ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.getFeatureByType().entrySet()) {
                FeatureBlock defaultLeaves = (FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get((TreeDefinition)((IFeatureSubtype)entry.getKey()));
                Object defaultLeavesBlock = defaultLeaves.block();
                Object fruitLeavesBlock = ((FeatureBlock)entry.getValue()).block();
                this.func_218522_a((Block)fruitLeavesBlock, block -> ForestryBlockLootTables.droppingWithChances(defaultLeavesBlock, (TreeDefinition)entry.getKey(), field_218579_g));
            }
            this.registerLootTable(CharcoalBlocks.ASH, (Block block) -> LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(CoreItems.ASH)).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)2, (float)0.33333334f)))).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151044_h)).func_212841_b_(CountBlockFunction.builder()).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.575f, (int)2))));
        }
        this.registerLootTable(CoreBlocks.PEAT, (Block block) -> LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_150346_d))).func_216040_a(LootPool.func_216096_a().func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(CoreItems.PEAT.item()))));
        this.registerDropping(CoreBlocks.HUMUS, (IItemProvider)Blocks.field_150346_d);
        this.func_218492_c((Block)((FeatureBlock)CoreBlocks.RESOURCE_ORE.get(EnumResourceType.TIN)).block());
        this.func_218492_c((Block)((FeatureBlock)CoreBlocks.RESOURCE_ORE.get(EnumResourceType.COPPER)).block());
        this.registerEmptyTables(ApicultureBlocks.CANDLE);
        this.registerEmptyTables(ApicultureBlocks.CANDLE_WALL);
        this.registerDropping(ApicultureBlocks.STUMP_WALL, ApicultureBlocks.STUMP);
        this.registerEmptyTables(ArboricultureBlocks.PODS);
        this.registerEmptyTables(ArboricultureBlocks.SAPLING_GE);
        this.registerEmptyTables(ArboricultureBlocks.LEAVES);
        this.registerEmptyTables(LepidopterologyBlocks.COCOON);
        this.registerEmptyTables(LepidopterologyBlocks.COCOON_SOLID);
        this.registerLootTable((FeatureBlock)CoreBlocks.RESOURCE_ORE.get(EnumResourceType.APATITE), (Block p_218548_0_) -> ForestryBlockLootTables.func_218519_a((Block)p_218548_0_, (LootEntry.Builder)((LootEntry.Builder)ForestryBlockLootTables.func_218552_a((IItemProvider)p_218548_0_, (ILootFunctionConsumer)ItemLootEntry.func_216168_a(CoreItems.APATITE.item()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)7.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215865_a((Enchantment)Enchantments.field_185308_t, (int)2))))));
        HashSet visited = Sets.newHashSet();
        for (IModFeature feature : ModuleManager.moduleHandler.getFeatures(type -> type.equals((Object)FeatureType.BLOCK))) {
            if (!(feature instanceof FeatureBlock)) {
                Log.error("Found feature of the type block that does not extends the \"FeatureBlock\" class.", new Object[0]);
                continue;
            }
            Object block2 = ((FeatureBlock)feature).block();
            ResourceLocation resourcelocation = block2.func_220068_i();
            if (resourcelocation == LootTables.field_186419_a || !visited.add(resourcelocation)) continue;
            LootTable.Builder builder = (LootTable.Builder)this.field_218581_i.remove(resourcelocation);
            if (builder == null) {
                builder = ForestryBlockLootTables.func_218546_a(block2);
            }
            consumer.accept(resourcelocation, builder);
        }
        if (!this.field_218581_i.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + this.field_218581_i.keySet());
        }
    }

    public void func_218564_a(Block blockIn, Block drop) {
        this.knownBlocks.add(blockIn);
        super.func_218564_a(blockIn, drop);
    }

    public void func_218522_a(Block blockIn, Function<Block, LootTable.Builder> builderFunction) {
        this.knownBlocks.add(blockIn);
        super.func_218522_a(blockIn, builderFunction);
    }

    public void func_218507_a(Block blockIn, LootTable.Builder builder) {
        this.knownBlocks.add(blockIn);
        super.func_218507_a(blockIn, builder);
    }

    public static LootTable.Builder droppingWithChances(Block block, TreeDefinition definition, float ... chances) {
        return ForestryBlockLootTables.func_218535_c((Block)block, (LootEntry.Builder)((StandaloneLootEntry.Builder)ForestryBlockLootTables.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a(ArboricultureItems.SAPLING).func_212841_b_(OrganismFunction.fromDefinition(definition)))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])chances)));
    }

    public void registerSilkTouch(FeatureBlock<?, ?> featureBlock, Block drop) {
        this.func_218564_a((Block)featureBlock.block(), drop);
    }

    public void registerSilkTouch(FeatureBlock<?, ?> featureBlock, FeatureBlock<?, ?> drop) {
        this.func_218564_a((Block)featureBlock.block(), (Block)drop.block());
    }

    public void registerLootTable(FeatureBlock<?, ?> featureBlock, Function<Block, LootTable.Builder> builderFunction) {
        this.func_218522_a((Block)featureBlock.block(), builderFunction);
    }

    public void registerDropping(FeatureBlock<?, ?> featureBlock, FeatureBlock<?, ?> drop) {
        this.func_218493_a((Block)featureBlock.block(), (IItemProvider)drop.block());
    }

    public void registerLootTable(FeatureBlock<?, ?> featureBlock, LootTable.Builder builder) {
        this.func_218507_a((Block)featureBlock.block(), builder);
    }

    public void registerDropping(FeatureBlock<?, ?> featureBlock, IItemProvider drop) {
        this.func_218493_a((Block)featureBlock.block(), drop);
    }

    public void registerEmptyTables(FeatureBlockGroup<?, ?> blockGroup) {
        this.registerEmptyTables(blockGroup.blockArray());
    }

    public void registerEmptyTables(FeatureBlock<?, ?> featureBlock) {
        this.registerEmptyTables(new Block[]{featureBlock.block()});
    }

    public void registerEmptyTables(Block ... blocks) {
        for (Block block : blocks) {
            this.func_218507_a(block, ForestryBlockLootTables.func_218482_a());
        }
    }
}

