/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.Table;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import forestry.arboriculture.features.ArboricultureItems;
import forestry.core.data.ModelProvider;
import forestry.core.fluids.ForestryFluids;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.cultivation.features.CultivationBlocks;
import forestry.farming.features.FarmingBlocks;
import forestry.lepidopterology.features.LepidopterologyItems;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureItem;
import forestry.storage.features.CrateItems;
import forestry.storage.models.CrateModel;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class ForestryItemModelProvider
extends ModelProvider {
    public ForestryItemModelProvider(DataGenerator generator) {
        super(generator, "item");
    }

    @Override
    protected void registerModels() {
        for (BlockItem blockItem : FarmingBlocks.FARM.getItems()) {
            this.registerModel((Item)blockItem, new ModelProvider.ModelBuilder().parent("forestry:block/farm"));
        }
        this.registerModel(LepidopterologyItems.CATERPILLAR_GE, new ModelProvider.ModelBuilder().item().layer(0, new ResourceLocation("forestry", "item/caterpillar.body2")).layer(1, new ResourceLocation("forestry", "item/caterpillar.body")));
        this.registerModel(LepidopterologyItems.SERUM_GE, new ModelProvider.ModelBuilder().item().layer(0, new ResourceLocation("forestry", "item/liquids/jar.bottle")).layer(1, new ResourceLocation("forestry", "item/liquids/jar.contents")));
        this.registerModel(ArboricultureItems.SAPLING, new ModelProvider.ModelBuilder().parent("forge:item/default").loader(new ResourceLocation("forestry", "sapling_ge")));
        for (FeatureItem featureItem : CrateItems.getCrates()) {
            this.registerModel(featureItem, new ModelProvider.ModelBuilder().parent("forestry:item/crate-filled").loader(CrateModel.Loader.LOCATION).loaderData("variant", (JsonElement)new JsonPrimitive(featureItem.getIdentifier())));
        }
        for (Table.Cell cell : CultivationBlocks.PLANTER.getFeatureByTypes().cellSet()) {
            Object block = ((FeatureBlock)cell.getValue()).block();
            this.registerModel((Block)block, new ModelProvider.ModelBuilder().parent("forestry:block/" + ((BlockTypePlanter)cell.getRowKey()).func_176610_l()));
        }
        for (Iterator<Object> iterator : ForestryFluids.values()) {
            BucketItem item = ((ForestryFluids)((Object)iterator)).getBucket();
            if (item == null) continue;
            this.registerModel((Item)item, new ModelProvider.ModelBuilder().loader(new ResourceLocation("forge", "bucket")).parent("forge:item/bucket_drip").loaderData("fluid", (JsonElement)new JsonPrimitive(((ForestryFluids)((Object)iterator)).getFluid().getRegistryName().toString())));
        }
    }
}

