/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.circuits.ICircuit;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.apiculture.items.EnumHoneyDrop;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.apiculture.items.EnumPropolis;
import forestry.climatology.features.ClimatologyItems;
import forestry.core.blocks.BlockTypeCoreTesr;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.data.ForestryTags;
import forestry.core.data.builder.CarpenterRecipeBuilder;
import forestry.core.data.builder.CentrifugeRecipeBuilder;
import forestry.core.data.builder.FabricatorRecipeBuilder;
import forestry.core.data.builder.FabricatorSmeltingRecipeBuilder;
import forestry.core.data.builder.FermenterRecipeBuilder;
import forestry.core.data.builder.HygroregulatorRecipeBuilder;
import forestry.core.data.builder.MoistenerRecipeBuilder;
import forestry.core.data.builder.SqueezerContainerRecipeBuilder;
import forestry.core.data.builder.SqueezerRecipeBuilder;
import forestry.core.data.builder.StillRecipeBuilder;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.features.FluidsItems;
import forestry.core.fluids.ForestryFluids;
import forestry.core.items.ItemFruit;
import forestry.core.items.definitions.EnumContainerType;
import forestry.core.items.definitions.EnumCraftingMaterial;
import forestry.core.items.definitions.EnumElectronTube;
import forestry.mail.features.MailItems;
import forestry.mail.items.ItemLetter;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureItem;
import forestry.storage.features.BackpackItems;
import forestry.storage.features.CrateItems;
import forestry.storage.items.ItemCrated;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;

public class ForestryMachineRecipeProvider
extends RecipeProvider {
    public ForestryMachineRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public String func_200397_b() {
        return "Machine Recipes";
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.registerCarpenter(consumer);
        this.registerCentrifuge(consumer);
        this.registerFabricator(consumer);
        this.registerFabricatorSmelting(consumer);
        this.registerFermenter(consumer);
        this.registerHygroregulator(consumer);
        this.registerMoistener(consumer);
        this.registerSqueezerContainer(consumer);
        this.registerSqueezer(consumer);
        this.registerStill(consumer);
    }

    private void registerCarpenter(Consumer<IFinishedRecipe> consumer) {
        new CarpenterRecipeBuilder().setPackagingTime(50).setLiquid(ForestryFluids.SEED_OIL.getFluid(250)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a(CoreItems.IMPREGNATED_CASING).func_200472_a("###").func_200472_a("# #").func_200472_a("###").func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_200038_h)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "impregnated_casing"));
        new CarpenterRecipeBuilder().setPackagingTime(50).setLiquid(ForestryFluids.SEED_OIL.getFluid(500)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a(((FeatureBlock)CoreBlocks.BASE.get(BlockTypeCoreTesr.ESCRITOIRE)).item()).func_200472_a("#  ").func_200472_a("###").func_200472_a("# #").func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_199905_b)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "escritoire"));
        new CarpenterRecipeBuilder().setPackagingTime(50).setLiquid(ForestryFluids.SEED_OIL.getFluid(100)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200468_a(CoreItems.STICK_IMPREGNATED, (int)2).func_200472_a("#").func_200472_a("#").func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_200038_h)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "impregnated_stick"));
        new CarpenterRecipeBuilder().setPackagingTime(5).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 250)).setBox(Ingredient.field_193370_a).recipe(ShapelessRecipeBuilder.func_200488_a(CoreItems.WOOD_PULP, (int)4).func_203221_a((ITag)ItemTags.field_200038_h)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "wood_pulp"));
        new CarpenterRecipeBuilder().setPackagingTime(5).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200468_a(CoreBlocks.HUMUS, (int)9).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221582_j).func_200462_a(Character.valueOf('X'), CoreItems.MULCH)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "humus"));
        new CarpenterRecipeBuilder().setPackagingTime(5).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200468_a(CoreBlocks.BOG_EARTH, (int)8).func_200472_a("#X#").func_200472_a("XYX").func_200472_a("#X#").func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221582_j).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.SAND).func_200462_a(Character.valueOf('Y'), CoreItems.MULCH)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "bog_earth"));
        new CarpenterRecipeBuilder().setPackagingTime(75).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 5000)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a(CoreItems.HARDENED_CASING).func_200472_a("X X").func_200472_a(" Y ").func_200472_a("X X").func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.GEMS_DIAMOND).func_200462_a(Character.valueOf('Y'), CoreItems.STURDY_CASING)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "hardened_casing"));
        new CarpenterRecipeBuilder().setPackagingTime(5).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a(CoreItems.IODINE_CHARGE).func_200472_a("Z#Z").func_200472_a("#Y#").func_200472_a("X#X").func_200462_a(Character.valueOf('#'), (IItemProvider)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.NORMAL)).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151016_H).func_200462_a(Character.valueOf('Y'), (IItemProvider)FluidsItems.CONTAINERS.get(EnumContainerType.CAN)).func_200462_a(Character.valueOf('Z'), (IItemProvider)ApicultureItems.HONEY_DROPS.get(EnumHoneyDrop.HONEY))).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "iodine_charge"));
        new CarpenterRecipeBuilder().setPackagingTime(5).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.DISSIPATION_CHARGE))).func_200472_a("Z#Z").func_200472_a("#Y#").func_200472_a("X#X").func_200462_a(Character.valueOf('#'), ApicultureItems.ROYAL_JELLY).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151016_H).func_200462_a(Character.valueOf('Y'), (IItemProvider)FluidsItems.CONTAINERS.get(EnumContainerType.CAN)).func_200462_a(Character.valueOf('Z'), ApicultureItems.HONEYDEW)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "dissipation_charge"));
        new CarpenterRecipeBuilder().setPackagingTime(100).setLiquid(null).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151079_bi).func_200472_a(" # ").func_200472_a("###").func_200472_a(" # ").func_200462_a(Character.valueOf('#'), (IItemProvider)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.PULSATING_MESH))).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "ender_pearl"));
        new CarpenterRecipeBuilder().setPackagingTime(10).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 500)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.WOVEN_SILK))).func_200472_a("XXX").func_200472_a("XXX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP))).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "woven_silk"));
        new CarpenterRecipeBuilder().setPackagingTime(5).setLiquid(null).setBox(Ingredient.field_193370_a).recipe(ShapelessRecipeBuilder.func_200488_a(CoreItems.INGOT_BRONZE, (int)2).func_200487_b(CoreItems.BRONZE_PICKAXE)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "reclaim_bronze_pickaxe"));
        new CarpenterRecipeBuilder().setPackagingTime(5).setLiquid(null).setBox(Ingredient.field_193370_a).recipe(ShapelessRecipeBuilder.func_200488_a(CoreItems.INGOT_BRONZE, (int)1).func_200487_b(CoreItems.BRONZE_SHOVEL)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "reclaim_bronze_shovel"));
        new CarpenterRecipeBuilder().setPackagingTime(50).setLiquid(ForestryFluids.HONEY.getFluid(500)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SCENTED_PANELING))).func_200472_a(" J ").func_200472_a("###").func_200472_a("WPW").func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_199905_b).func_200462_a(Character.valueOf('J'), ApicultureItems.ROYAL_JELLY).func_200462_a(Character.valueOf('W'), CoreItems.BEESWAX).func_200462_a(Character.valueOf('P'), (IItemProvider)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.NORMAL))).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "scented_paneling"));
        new CarpenterRecipeBuilder().setPackagingTime(30).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 600)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200468_a(ApicultureBlocks.CANDLE, (int)24).func_200472_a(" X ").func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), CoreItems.BEESWAX).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151007_F)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "candle_string"));
        new CarpenterRecipeBuilder().setPackagingTime(10).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 200)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200468_a(ApicultureBlocks.CANDLE, (int)6).func_200472_a("#X#").func_200462_a(Character.valueOf('#'), CoreItems.BEESWAX).func_200462_a(Character.valueOf('X'), (IItemProvider)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.SILK_WISP))).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "candle_silk_wisp"));
        new CarpenterRecipeBuilder().setPackagingTime(100).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 2000)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a(CoreItems.PORTABLE_ALYZER).func_200472_a("X#X").func_200472_a("X#X").func_200472_a("RDR").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.GLASS_PANES).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_TIN).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('D'), (ITag)Tags.Items.GEMS_DIAMOND)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "portable_analyzer"));
        new CarpenterRecipeBuilder().setPackagingTime(20).setLiquid(null).setBox(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.CARTON})).recipe(ShapedRecipeBuilder.func_200470_a(CoreItems.KIT_PICKAXE).func_200472_a("###").func_200472_a(" X ").func_200472_a(" X ").func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151055_y)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "kit_pickaxe"));
        new CarpenterRecipeBuilder().setPackagingTime(20).setLiquid(null).setBox(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.CARTON})).recipe(ShapedRecipeBuilder.func_200470_a(CoreItems.KIT_SHOVEL).func_200472_a(" # ").func_200472_a(" X ").func_200472_a(" X ").func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151055_y)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "kit_shovel"));
        new CarpenterRecipeBuilder().setPackagingTime(40).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a(CoreItems.SOLDERING_IRON).func_200472_a(" # ").func_200472_a("# #").func_200472_a("  B").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('B'), ForestryTags.Items.INGOTS_BRONZE)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "soldering_iron"));
        new CarpenterRecipeBuilder().setPackagingTime(5).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 250)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151121_aF).func_200472_a("#").func_200472_a("#").func_200462_a(Character.valueOf('#'), CoreItems.WOOD_PULP)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "paper"));
        new CarpenterRecipeBuilder().setPackagingTime(5).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200468_a(CoreItems.CARTON, (int)2).func_200472_a(" # ").func_200472_a("# #").func_200472_a(" # ").func_200462_a(Character.valueOf('#'), CoreItems.WOOD_PULP)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "carton"));
        ItemStack basic = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.BASIC, null, new ICircuit[0]);
        ItemStack enhanced = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.ENHANCED, null, new ICircuit[0]);
        ItemStack refined = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0]);
        ItemStack intricate = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.INTRICATE, null, new ICircuit[0]);
        new CarpenterRecipeBuilder().setPackagingTime(20).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).setBox(Ingredient.field_193370_a).override(basic).recipe(ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.BASIC))).func_200472_a("R R").func_200472_a("R#R").func_200472_a("R R").func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_TIN).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "circuits", "basic"));
        new CarpenterRecipeBuilder().setPackagingTime(40).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).setBox(Ingredient.field_193370_a).override(enhanced).recipe(ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.ENHANCED))).func_200472_a("R#R").func_200472_a("R#R").func_200472_a("R#R").func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "circuits", "enhanced"));
        new CarpenterRecipeBuilder().setPackagingTime(80).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).setBox(Ingredient.field_193370_a).override(refined).recipe(ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.REFINED))).func_200472_a("R#R").func_200472_a("R#R").func_200472_a("R#R").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "circuits", "refined"));
        new CarpenterRecipeBuilder().setPackagingTime(80).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).setBox(Ingredient.field_193370_a).override(intricate).recipe(ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)CoreItems.CIRCUITBOARDS.get(EnumCircuitBoardType.INTRICATE))).func_200472_a("R#R").func_200472_a("R#R").func_200472_a("R#R").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "circuits", "intricate"));
        new CarpenterRecipeBuilder().setPackagingTime(100).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 2000)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a(ClimatologyItems.HABITAT_SCREEN).func_200472_a("IPI").func_200472_a("IPI").func_200472_a("GDG").func_200462_a(Character.valueOf('G'), CoreItems.GEAR_BRONZE).func_200469_a(Character.valueOf('P'), (ITag)Tags.Items.GLASS_PANES).func_200462_a(Character.valueOf('I'), CoreItems.INGOT_BRONZE).func_200469_a(Character.valueOf('D'), (ITag)Tags.Items.GEMS_DIAMOND)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "habitat_screen"));
        new CarpenterRecipeBuilder().setPackagingTime(20).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200468_a(CrateItems.CRATE, (int)24).func_200472_a(" # ").func_200472_a("# #").func_200472_a(" # ").func_200469_a(Character.valueOf('#'), (ITag)ItemTags.field_200038_h)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "crates", "empty"));
        this.crate(consumer, CrateItems.CRATED_PEAT.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.PEAT}));
        this.crate(consumer, CrateItems.CRATED_APATITE.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.APATITE}));
        this.crate(consumer, CrateItems.CRATED_FERTILIZER_COMPOUND.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.FERTILIZER_COMPOUND}));
        this.crate(consumer, CrateItems.CRATED_MULCH.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.MULCH}));
        this.crate(consumer, CrateItems.CRATED_PHOSPHOR.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.PHOSPHOR}));
        this.crate(consumer, CrateItems.CRATED_ASH.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.ASH}));
        this.crate(consumer, CrateItems.CRATED_TIN.get(), Ingredient.func_199805_a(ForestryTags.Items.INGOTS_TIN));
        this.crate(consumer, CrateItems.CRATED_COPPER.get(), Ingredient.func_199805_a(ForestryTags.Items.INGOTS_COPPER));
        this.crate(consumer, CrateItems.CRATED_BRONZE.get(), Ingredient.func_199805_a(ForestryTags.Items.INGOTS_BRONZE));
        this.crate(consumer, CrateItems.CRATED_HUMUS.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreBlocks.HUMUS}));
        this.crate(consumer, CrateItems.CRATED_BOG_EARTH.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreBlocks.BOG_EARTH}));
        this.crate(consumer, CrateItems.CRATED_WHEAT.get(), Ingredient.func_199805_a((ITag)Tags.Items.CROPS_WHEAT));
        this.crate(consumer, CrateItems.CRATED_COOKIE.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151106_aX}));
        this.crate(consumer, CrateItems.CRATED_REDSTONE.get(), Ingredient.func_199805_a((ITag)Tags.Items.DUSTS_REDSTONE));
        this.crate(consumer, CrateItems.CRATED_LAPIS.get(), Ingredient.func_199805_a((ITag)Tags.Items.GEMS_LAPIS));
        this.crate(consumer, CrateItems.CRATED_SUGAR_CANE.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222065_kN}));
        this.crate(consumer, CrateItems.CRATED_CLAY_BALL.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151119_aD}));
        this.crate(consumer, CrateItems.CRATED_GLOWSTONE.get(), Ingredient.func_199805_a((ITag)Tags.Items.DUSTS_GLOWSTONE));
        this.crate(consumer, CrateItems.CRATED_APPLE.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151034_e}));
        this.crate(consumer, CrateItems.CRATED_COAL.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151044_h}));
        this.crate(consumer, CrateItems.CRATED_CHARCOAL.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196155_l}));
        this.crate(consumer, CrateItems.CRATED_SEEDS.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N}));
        this.crate(consumer, CrateItems.CRATED_POTATO.get(), Ingredient.func_199805_a((ITag)Tags.Items.CROPS_POTATO));
        this.crate(consumer, CrateItems.CRATED_CARROT.get(), Ingredient.func_199805_a((ITag)Tags.Items.CROPS_CARROT));
        this.crate(consumer, CrateItems.CRATED_BEETROOT.get(), Ingredient.func_199805_a((ITag)Tags.Items.CROPS_BEETROOT));
        this.crate(consumer, CrateItems.CRATED_NETHER_WART.get(), Ingredient.func_199805_a((ITag)Tags.Items.CROPS_NETHER_WART));
        this.crate(consumer, CrateItems.CRATED_OAK_LOG.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221554_G}));
        this.crate(consumer, CrateItems.CRATED_BIRCH_LOG.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221556_I}));
        this.crate(consumer, CrateItems.CRATED_JUNGLE_LOG.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221557_J}));
        this.crate(consumer, CrateItems.CRATED_SPRUCE_LOG.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221555_H}));
        this.crate(consumer, CrateItems.CRATED_ACACIA_LOG.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221558_K}));
        this.crate(consumer, CrateItems.CRATED_DARK_OAK_LOG.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221559_L}));
        this.crate(consumer, CrateItems.CRATED_COBBLESTONE.get(), Ingredient.func_199805_a((ITag)Tags.Items.COBBLESTONE));
        this.crate(consumer, CrateItems.CRATED_DIRT.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j}));
        this.crate(consumer, CrateItems.CRATED_GRASS_BLOCK.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221581_i}));
        this.crate(consumer, CrateItems.CRATED_STONE.get(), Ingredient.func_199805_a((ITag)Tags.Items.STONE));
        this.crate(consumer, CrateItems.CRATED_GRANITE.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221575_c}));
        this.crate(consumer, CrateItems.CRATED_DIORITE.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221577_e}));
        this.crate(consumer, CrateItems.CRATED_ANDESITE.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221579_g}));
        this.crate(consumer, CrateItems.CRATED_PRISMARINE.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221879_fX}));
        this.crate(consumer, CrateItems.CRATED_PRISMARINE_BRICKS.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221881_fY}));
        this.crate(consumer, CrateItems.CRATED_DARK_PRISMARINE.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221883_fZ}));
        this.crate(consumer, CrateItems.CRATED_BRICKS.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221647_bL}));
        this.crate(consumer, CrateItems.CRATED_CACTUS.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221774_cw}));
        this.crate(consumer, CrateItems.CRATED_SAND.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221548_A}));
        this.crate(consumer, CrateItems.CRATED_RED_SAND.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221549_B}));
        this.crate(consumer, CrateItems.CRATED_OBSIDIAN.get(), Ingredient.func_199805_a((ITag)Tags.Items.OBSIDIAN));
        this.crate(consumer, CrateItems.CRATED_NETHERRACK.get(), Ingredient.func_199805_a((ITag)Tags.Items.NETHERRACK));
        this.crate(consumer, CrateItems.CRATED_SOUL_SAND.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221693_cI}));
        this.crate(consumer, CrateItems.CRATED_SANDSTONE.get(), Ingredient.func_199805_a((ITag)Tags.Items.SANDSTONE));
        this.crate(consumer, CrateItems.CRATED_NETHER_BRICKS.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221818_ds}));
        this.crate(consumer, CrateItems.CRATED_MYCELIUM.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221814_dq}));
        this.crate(consumer, CrateItems.CRATED_GRAVEL.get(), Ingredient.func_199805_a((ITag)Tags.Items.GRAVEL));
        this.crate(consumer, CrateItems.CRATED_OAK_SAPLING.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221592_t}));
        this.crate(consumer, CrateItems.CRATED_BIRCH_SAPLING.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221594_v}));
        this.crate(consumer, CrateItems.CRATED_JUNGLE_SAPLING.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221595_w}));
        this.crate(consumer, CrateItems.CRATED_SPRUCE_SAPLING.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221593_u}));
        this.crate(consumer, CrateItems.CRATED_ACACIA_SAPLING.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221596_x}));
        this.crate(consumer, CrateItems.CRATED_DARK_OAK_SAPLING.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221597_y}));
        this.crate(consumer, CrateItems.CRATED_BEESWAX.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.BEESWAX}));
        this.crate(consumer, CrateItems.CRATED_REFRACTORY_WAX.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.REFRACTORY_WAX}));
        this.crate(consumer, CrateItems.CRATED_POLLEN_CLUSTER_NORMAL.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.NORMAL)}));
        this.crate(consumer, CrateItems.CRATED_POLLEN_CLUSTER_CRYSTALLINE.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.POLLEN_CLUSTER.get(EnumPollenCluster.CRYSTALLINE)}));
        this.crate(consumer, CrateItems.CRATED_PROPOLIS.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.PROPOLIS.get(EnumPropolis.NORMAL)}));
        this.crate(consumer, CrateItems.CRATED_HONEYDEW.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ApicultureItems.HONEYDEW}));
        this.crate(consumer, CrateItems.CRATED_ROYAL_JELLY.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ApicultureItems.ROYAL_JELLY}));
        for (EnumHoneyComb comb : EnumHoneyComb.VALUES) {
            this.crate(consumer, (ItemCrated)((FeatureItem)CrateItems.CRATED_BEE_COMBS.get(comb)).get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(comb)}));
        }
        new CarpenterRecipeBuilder().setPackagingTime(10).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 250)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a(((FeatureItem)MailItems.LETTERS.get(ItemLetter.Size.EMPTY, ItemLetter.State.FRESH)).item()).func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), CoreItems.WOOD_PULP)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "letter_pulp"));
        this.wovenBackpack(consumer, "miner", BackpackItems.MINER_BACKPACK, BackpackItems.MINER_BACKPACK_T_2);
        this.wovenBackpack(consumer, "digger", BackpackItems.DIGGER_BACKPACK, BackpackItems.DIGGER_BACKPACK_T_2);
        this.wovenBackpack(consumer, "forester", BackpackItems.FORESTER_BACKPACK, BackpackItems.FORESTER_BACKPACK_T_2);
        this.wovenBackpack(consumer, "hunter", BackpackItems.HUNTER_BACKPACK, BackpackItems.HUNTER_BACKPACK_T_2);
        this.wovenBackpack(consumer, "adventurer", BackpackItems.ADVENTURER_BACKPACK, BackpackItems.ADVENTURER_BACKPACK_T_2);
        this.wovenBackpack(consumer, "builder", BackpackItems.BUILDER_BACKPACK, BackpackItems.BUILDER_BACKPACK_T_2);
    }

    private void wovenBackpack(Consumer<IFinishedRecipe> consumer, String id, FeatureItem<?> tier1, FeatureItem<?> tier2) {
        new CarpenterRecipeBuilder().setPackagingTime(200).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).setBox(Ingredient.field_193370_a).recipe(ShapedRecipeBuilder.func_200470_a(tier2).func_200472_a("WXW").func_200472_a("WTW").func_200472_a("WWW").func_200462_a(Character.valueOf('W'), (IItemProvider)CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.WOVEN_SILK).func_77973_b()).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200462_a(Character.valueOf('T'), tier1)).build(consumer, ForestryMachineRecipeProvider.id("woven_backpack", id));
    }

    private void crate(Consumer<IFinishedRecipe> consumer, ItemCrated crated, Ingredient ingredient) {
        ItemStack contained = crated.getContained();
        ResourceLocation name = contained.func_77973_b().getRegistryName();
        if (name == null) {
            return;
        }
        new CarpenterRecipeBuilder().setPackagingTime(5).setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 100)).setBox(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CrateItems.CRATE})).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)crated, (int)1).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200471_a(Character.valueOf('#'), ingredient)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "crates", "pack", name.func_110624_b(), name.func_110623_a()));
        new CarpenterRecipeBuilder().setPackagingTime(5).setLiquid(null).setBox(Ingredient.field_193370_a).recipe(ShapelessRecipeBuilder.func_200488_a((IItemProvider)contained.func_77973_b(), (int)9).func_200487_b((IItemProvider)crated)).build(consumer, ForestryMachineRecipeProvider.id("carpenter", "crates", "unpack", name.func_110624_b(), name.func_110623_a()));
    }

    private void registerCentrifuge(Consumer<IFinishedRecipe> consumer) {
        new CentrifugeRecipeBuilder().setProcessingTime(5).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151007_F})).product(0.15f, CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.SILK_WISP, 1)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "string"));
        ItemStack honeyDrop = ApicultureItems.HONEY_DROPS.stack(EnumHoneyDrop.HONEY, 1);
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.HONEY)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.9f, honeyDrop).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "honey_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.COCOA)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.5f, new ItemStack((IItemProvider)Items.field_196130_bo)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "cocoa_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.SIMMERING)})).product(1.0f, CoreItems.REFRACTORY_WAX.stack()).product(0.7f, CoreItems.PHOSPHOR.stack(2)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "simmering_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.STRINGY)})).product(1.0f, ApicultureItems.PROPOLIS.stack(EnumPropolis.NORMAL, 1)).product(0.4f, honeyDrop).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "stringy_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.DRIPPING)})).product(1.0f, ApicultureItems.HONEYDEW.stack()).product(0.4f, honeyDrop).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "dripping_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.FROZEN)})).product(0.8f, CoreItems.BEESWAX.stack()).product(0.7f, honeyDrop).product(0.4f, new ItemStack((IItemProvider)Items.field_151126_ay)).product(0.2f, ApicultureItems.POLLEN_CLUSTER.stack(EnumPollenCluster.CRYSTALLINE, 1)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "frozen_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.SILKY)})).product(1.0f, honeyDrop).product(0.8f, ApicultureItems.PROPOLIS.stack(EnumPropolis.SILKY, 1)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "silky_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.PARCHED)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.9f, honeyDrop).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "parched_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.MYSTERIOUS)})).product(1.0f, ApicultureItems.PROPOLIS.stack(EnumPropolis.PULSATING, 1)).product(0.4f, honeyDrop).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "mysterious_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.IRRADIATED)})).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "irradiated_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.POWDERY)})).product(0.2f, honeyDrop).product(0.2f, CoreItems.BEESWAX.stack()).product(0.9f, new ItemStack((IItemProvider)Items.field_151016_H)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "powdery_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.WHEATEN)})).product(0.2f, honeyDrop).product(0.2f, CoreItems.BEESWAX.stack()).product(0.8f, new ItemStack((IItemProvider)Items.field_151015_O)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "wheaten_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.MOSSY)})).product(1.0f, CoreItems.BEESWAX.stack()).product(0.9f, honeyDrop).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "mossy_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(20).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.BEE_COMBS.get(EnumHoneyComb.MELLOW)})).product(0.6f, ApicultureItems.HONEYDEW.stack()).product(0.2f, CoreItems.BEESWAX.stack()).product(0.3f, new ItemStack((IItemProvider)Items.field_151128_bU)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "mellow_comb"));
        new CentrifugeRecipeBuilder().setProcessingTime(5).setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.PROPOLIS.get(EnumPropolis.SILKY)})).product(0.6f, CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.SILK_WISP, 1)).product(0.1f, ApicultureItems.PROPOLIS.stack(EnumPropolis.NORMAL, 1)).build(consumer, ForestryMachineRecipeProvider.id("centrifuge", "silky_propolis"));
    }

    private void registerFabricator(Consumer<IFinishedRecipe> consumer) {
        FluidStack liquidGlass = ForestryFluids.GLASS.getFluid(500);
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.IRON)), (int)4).func_200472_a(" X ").func_200472_a("#X#").func_200472_a("XXX").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.INGOTS_IRON)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "iron"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.GOLD)), (int)4).func_200472_a(" X ").func_200472_a("#X#").func_200472_a("XXX").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.INGOTS_GOLD)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "gold"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.DIAMOND)), (int)4).func_200472_a(" X ").func_200472_a("#X#").func_200472_a("XXX").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.GEMS_DIAMOND)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "diamond"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.OBSIDIAN)), (int)4).func_200472_a(" X ").func_200472_a("#X#").func_200472_a("XXX").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_221655_bP)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "obsidian"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.BLAZE)), (int)4).func_200472_a(" X ").func_200472_a("#X#").func_200472_a("XXX").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151065_br)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "blaze"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.EMERALD)), (int)4).func_200472_a(" X ").func_200472_a("#X#").func_200472_a("XXX").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.GEMS_EMERALD)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "emerald"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.LAPIS)), (int)4).func_200472_a(" X ").func_200472_a("#X#").func_200472_a("XXX").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.GEMS_LAPIS)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "lapis"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.ENDER)), (int)4).func_200472_a(" X ").func_200472_a("#X#").func_200472_a("XXX").func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151061_bv).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_221828_dx)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "ender"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.ORCHID)), (int)4).func_200472_a(" X ").func_200472_a("#X#").func_200472_a("XXX").func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_222027_iT).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_221762_cq)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "orchid"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.COPPER)), (int)4).func_200472_a(" X ").func_200472_a("#X#").func_200472_a("XXX").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_COPPER)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "copper"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.TIN)), (int)4).func_200472_a(" X ").func_200472_a("#X#").func_200472_a("XXX").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_TIN)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "tin"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.BRONZE)), (int)4).func_200472_a(" X ").func_200472_a("#X#").func_200472_a("XXX").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('X'), ForestryTags.Items.INGOTS_BRONZE)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "bronze"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)CoreItems.ELECTRON_TUBES.get(EnumElectronTube.APATITE)), (int)4).func_200472_a(" X ").func_200472_a("#X#").func_200472_a("XXX").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('X'), ForestryTags.Items.GEMS_APATITE)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "apatite"));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200470_a(CoreItems.FLEXIBLE_CASING).func_200472_a("#E#").func_200472_a("B B").func_200472_a("#E#").func_200469_a(Character.valueOf('#'), ForestryTags.Items.INGOTS_BRONZE).func_200469_a(Character.valueOf('B'), (ITag)Tags.Items.SLIMEBALLS).func_200469_a(Character.valueOf('E'), (ITag)Tags.Items.GEMS_EMERALD)).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "electron_tubes", "flexible_casing"));
        for (EnumForestryWoodType enumForestryWoodType : EnumForestryWoodType.values()) {
            this.addFireproofRecipes(consumer, enumForestryWoodType);
        }
        for (Enum enum_ : EnumVanillaWoodType.values()) {
            this.addFireproofRecipes(consumer, (IWoodType)((Object)enum_));
        }
    }

    private void addFireproofRecipes(Consumer<IFinishedRecipe> consumer, IWoodType type) {
        FluidStack liquidGlass = ForestryFluids.GLASS.getFluid(500);
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200470_a((IItemProvider)TreeManager.woodAccess.getBlock(type, WoodBlockKind.LOG, true).func_177230_c()).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200462_a(Character.valueOf('#'), CoreItems.REFRACTORY_WAX).func_200462_a(Character.valueOf('X'), (IItemProvider)TreeManager.woodAccess.getBlock(type, WoodBlockKind.LOG, false).func_177230_c())).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "fireproof", "logs", type.toString()));
        new FabricatorRecipeBuilder().setPlan(Ingredient.field_193370_a).setMolten(liquidGlass).recipe(ShapedRecipeBuilder.func_200468_a((IItemProvider)TreeManager.woodAccess.getBlock(type, WoodBlockKind.PLANKS, true).func_177230_c(), (int)5).func_200472_a("X#X").func_200472_a("#X#").func_200472_a("X#X").func_200462_a(Character.valueOf('#'), CoreItems.REFRACTORY_WAX).func_200462_a(Character.valueOf('X'), (IItemProvider)TreeManager.woodAccess.getBlock(type, WoodBlockKind.PLANKS, false).func_177230_c())).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "fireproof", "planks", type.toString()));
    }

    private void registerFabricatorSmelting(Consumer<IFinishedRecipe> consumer) {
        FluidStack liquidGlassBucket = ForestryFluids.GLASS.getFluid(1000);
        FluidStack liquidGlassX4 = ForestryFluids.GLASS.getFluid(4000);
        FluidStack liquidGlass375 = ForestryFluids.GLASS.getFluid(375);
        new FabricatorSmeltingRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221650_am})).setProduct(liquidGlassBucket).setMeltingPoint(1000).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "smelting", "glass"));
        new FabricatorSmeltingRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221792_df})).setProduct(liquidGlass375).setMeltingPoint(1000).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "smelting", "glass_pane"));
        new FabricatorSmeltingRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221548_A, Items.field_221549_B})).setProduct(liquidGlassBucket).setMeltingPoint(3000).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "smelting", "sand"));
        new FabricatorSmeltingRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221658_aq, Items.field_221643_bJ, Items.field_221660_ar})).setProduct(liquidGlassX4).setMeltingPoint(4800).build(consumer, ForestryMachineRecipeProvider.id("fabricator", "smelting", "sandstone"));
    }

    private void registerFermenter(Consumer<IFinishedRecipe> consumer) {
        new FermenterRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221692_bh})).setFermentationValue(50).setModifier(1.5f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(ForestryFluids.HONEY.getFluid(1)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "brown_mushroom_honey"));
        new FermenterRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221692_bh})).setFermentationValue(50).setModifier(1.5f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(ForestryFluids.JUICE.getFluid(1)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "brown_mushroom_juice"));
        new FermenterRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221694_bi})).setFermentationValue(50).setModifier(1.5f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(ForestryFluids.HONEY.getFluid(1)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "red_mushroom_honey"));
        new FermenterRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221694_bi})).setFermentationValue(50).setModifier(1.5f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(ForestryFluids.JUICE.getFluid(1)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "red_mushroom_juice"));
        FluidStack shortMead = ForestryFluids.SHORT_MEAD.getFluid(1);
        FluidStack honey = ForestryFluids.HONEY.getFluid(1);
        new FermenterRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ApicultureItems.HONEYDEW})).setFermentationValue(500).setModifier(1.0f).setOutput(shortMead.getFluid()).setFluidResource(honey).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "honeydew"));
        new FermenterRecipeBuilder().setResource(Ingredient.func_199805_a((ITag)ItemTags.field_200037_g)).setFermentationValue(250).setModifier(1.0f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "sapling"));
        new FermenterRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221774_cw})).setFermentationValue(50).setModifier(1.0f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "cactus"));
        new FermenterRecipeBuilder().setResource(Ingredient.func_199805_a((ITag)Tags.Items.CROPS_WHEAT)).setFermentationValue(50).setModifier(1.0f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "wheat"));
        new FermenterRecipeBuilder().setResource(Ingredient.func_199805_a((ITag)Tags.Items.CROPS_POTATO)).setFermentationValue(100).setModifier(1.0f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "potato"));
        new FermenterRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222065_kN})).setFermentationValue(50).setModifier(1.0f).setOutput(ForestryFluids.BIOMASS.getFluid()).setFluidResource(new FluidStack((Fluid)Fluids.field_204546_a, 1000)).build(consumer, ForestryMachineRecipeProvider.id("fermenter", "sugar_cane"));
    }

    private void registerHygroregulator(Consumer<IFinishedRecipe> consumer) {
        new HygroregulatorRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.field_204546_a, 1)).setTransferTime(1).setTempChange(-0.005f).setHumidChange(0.01f).build(consumer, ForestryMachineRecipeProvider.id("hygroregulator", "water"));
        new HygroregulatorRecipeBuilder().setLiquid(new FluidStack((Fluid)Fluids.field_204547_b, 1)).setTransferTime(10).setTempChange(0.005f).setHumidChange(-0.01f).build(consumer, ForestryMachineRecipeProvider.id("hygroregulator", "lava"));
        new HygroregulatorRecipeBuilder().setLiquid(ForestryFluids.ICE.getFluid(1)).setTransferTime(10).setTempChange(-0.01f).setHumidChange(0.02f).build(consumer, ForestryMachineRecipeProvider.id("hygroregulator", "ice"));
    }

    private void registerMoistener(Consumer<IFinishedRecipe> consumer) {
        new MoistenerRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N})).setProduct(new ItemStack((IItemProvider)Items.field_221814_dq)).setTimePerItem(5000).build(consumer, ForestryMachineRecipeProvider.id("moistener", "mycelium"));
        new MoistenerRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221585_m})).setProduct(new ItemStack((IItemProvider)Items.field_221653_bO)).setTimePerItem(20000).build(consumer, ForestryMachineRecipeProvider.id("moistener", "mossy_cobblestone"));
        new MoistenerRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221723_cX})).setProduct(new ItemStack((IItemProvider)Items.field_221725_cY)).setTimePerItem(20000).build(consumer, ForestryMachineRecipeProvider.id("moistener", "mossy_stone_bricks"));
        new MoistenerRecipeBuilder().setResource(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221636_af})).setProduct(new ItemStack((IItemProvider)Items.field_221584_l)).setTimePerItem(5000).build(consumer, ForestryMachineRecipeProvider.id("moistener", "podzol"));
    }

    private void registerSqueezerContainer(Consumer<IFinishedRecipe> consumer) {
        new SqueezerContainerRecipeBuilder().setProcessingTime(10).setEmptyContainer(FluidsItems.CONTAINERS.stack(EnumContainerType.CAN)).setRemnants(CoreItems.INGOT_TIN.stack()).setRemnantsChance(0.05f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "container", "can"));
        new SqueezerContainerRecipeBuilder().setProcessingTime(10).setEmptyContainer(FluidsItems.CONTAINERS.stack(EnumContainerType.CAPSULE)).setRemnants(CoreItems.BEESWAX.stack()).setRemnantsChance(0.1f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "container", "capsule"));
        new SqueezerContainerRecipeBuilder().setProcessingTime(10).setEmptyContainer(FluidsItems.CONTAINERS.stack(EnumContainerType.REFRACTORY)).setRemnants(CoreItems.REFRACTORY_WAX.stack()).setRemnantsChance(0.1f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "container", "refractory"));
    }

    private void registerSqueezer(Consumer<IFinishedRecipe> consumer) {
        FluidStack honeyDropFluid = ForestryFluids.HONEY.getFluid(100);
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ApicultureItems.HONEY_DROPS.get(EnumHoneyDrop.HONEY)}))).setFluidOutput(honeyDropFluid).setRemnants(ApicultureItems.PROPOLIS.stack(EnumPropolis.NORMAL, 1)).setRemnantsChance(0.05f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "honey_drop"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ApicultureItems.HONEYDEW}))).setFluidOutput(honeyDropFluid).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "honey_dew"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)((NonNullList)Util.func_200696_a((Object)NonNullList.func_191196_a(), ingredients -> {
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.PHOSPHOR}));
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.PHOSPHOR}));
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221548_A, Items.field_221549_B}));
        }))).setFluidOutput(new FluidStack((Fluid)Fluids.field_204547_b, 2000)).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "lava_sand"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)((NonNullList)Util.func_200696_a((Object)NonNullList.func_191196_a(), ingredients -> {
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.PHOSPHOR}));
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{CoreItems.PHOSPHOR}));
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221585_m}));
        }))).setFluidOutput(new FluidStack((Fluid)Fluids.field_204547_b, 1600)).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "lava"));
        int seedOilAmount = 10;
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199805_a((ITag)Tags.Items.SEEDS))).setFluidOutput(ForestryFluids.SEED_OIL.getFluid(seedOilAmount)).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "seeds"));
        int appleMulchAmount = 20;
        int appleJuiceAmount = 200;
        FluidStack appleJuice = ForestryFluids.JUICE.getFluid(appleJuiceAmount);
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151034_e, Items.field_151172_bF}))).setFluidOutput(appleJuice).setRemnants(CoreItems.MULCH.stack()).setRemnantsChance((float)appleMulchAmount / 100.0f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "mulch"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221774_cw}))).setFluidOutput(new FluidStack((Fluid)Fluids.field_204546_a, 500)).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "cactus"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)((NonNullList)Util.func_200696_a((Object)NonNullList.func_191196_a(), ingredients -> {
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151126_ay}));
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.ICE_SHARD)}));
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.ICE_SHARD)}));
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.ICE_SHARD)}));
            ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreItems.CRAFTING_MATERIALS.get(EnumCraftingMaterial.ICE_SHARD)}));
        }))).setFluidOutput(ForestryFluids.ICE.getFluid(4000)).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "ice"));
        int seedOilMultiplier = 10;
        int juiceMultiplier = 200;
        ItemStack mulch = new ItemStack(CoreItems.MULCH);
        Fluid seedOil = ForestryFluids.SEED_OIL.getFluid();
        Fluid juice = ForestryFluids.JUICE.getFluid();
        new SqueezerRecipeBuilder().setProcessingTime(20).setResources((NonNullList<Ingredient>)NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreItems.FRUITS.get(ItemFruit.EnumFruit.CHERRY)}))).setFluidOutput(new FluidStack(seedOil, seedOilMultiplier * 5)).setRemnants(mulch).setRemnantsChance(0.05f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "cherry"));
        new SqueezerRecipeBuilder().setProcessingTime(60).setResources((NonNullList<Ingredient>)NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreItems.FRUITS.get(ItemFruit.EnumFruit.WALNUT)}))).setFluidOutput(new FluidStack(seedOil, seedOilMultiplier * 18)).setRemnants(mulch).setRemnantsChance(0.05f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "walnut"));
        new SqueezerRecipeBuilder().setProcessingTime(70).setResources((NonNullList<Ingredient>)NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreItems.FRUITS.get(ItemFruit.EnumFruit.CHESTNUT)}))).setFluidOutput(new FluidStack(seedOil, seedOilMultiplier * 22)).setRemnants(mulch).setRemnantsChance(0.02f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "chestnut"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreItems.FRUITS.get(ItemFruit.EnumFruit.LEMON)}))).setFluidOutput(new FluidStack(juice, juiceMultiplier * 2)).setRemnants(mulch).setRemnantsChance(1.0f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "lemon"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreItems.FRUITS.get(ItemFruit.EnumFruit.PLUM)}))).setFluidOutput(new FluidStack(juice, juiceMultiplier / 2)).setRemnants(mulch).setRemnantsChance(1.0f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "plum"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreItems.FRUITS.get(ItemFruit.EnumFruit.PAPAYA)}))).setFluidOutput(new FluidStack(juice, juiceMultiplier * 3)).setRemnants(mulch).setRemnantsChance(1.0f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "papaya"));
        new SqueezerRecipeBuilder().setProcessingTime(10).setResources((NonNullList<Ingredient>)NonNullList.func_191197_a((int)1, (Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CoreItems.FRUITS.get(ItemFruit.EnumFruit.DATES)}))).setFluidOutput(new FluidStack(juice, juiceMultiplier / 4)).setRemnants(mulch).setRemnantsChance(1.0f).build(consumer, ForestryMachineRecipeProvider.id("squeezer", "fruit", "dates"));
    }

    private void registerStill(Consumer<IFinishedRecipe> consumer) {
        FluidStack biomass = ForestryFluids.BIOMASS.getFluid(10);
        FluidStack ethanol = ForestryFluids.BIO_ETHANOL.getFluid(3);
        new StillRecipeBuilder().setTimePerUnit(100).setInput(biomass).setOutput(ethanol).build(consumer, ForestryMachineRecipeProvider.id("still", "ethanol"));
    }

    private static ResourceLocation id(String ... path) {
        return new ResourceLocation("forestry", String.join((CharSequence)"/", path));
    }
}

