/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.blocks.BlockDefaultLeaves;
import forestry.arboriculture.blocks.BlockDefaultLeavesFruit;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.core.data.BlockStateProvider;
import forestry.modules.features.FeatureBlock;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;

public class WoodBlockStateProvider
extends BlockStateProvider {
    public WoodBlockStateProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public void registerStates() {
        for (Map.Entry entry : ArboricultureBlocks.PLANKS.getFeatureByType().entrySet()) {
            this.addPlank((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.PLANKS_FIREPROOF.getFeatureByType().entrySet()) {
            this.addPlank((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.PLANKS_VANILLA_FIREPROOF.getFeatureByType().entrySet()) {
            this.addPlank((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.LOGS.getFeatureByType().entrySet()) {
            this.addLog((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.LOGS_FIREPROOF.getFeatureByType().entrySet()) {
            this.addLog((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.LOGS_VANILLA_FIREPROOF.getFeatureByType().entrySet()) {
            this.addLog((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.STAIRS.getFeatureByType().entrySet()) {
            this.addStair((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.STAIRS_FIREPROOF.getFeatureByType().entrySet()) {
            this.addStair((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.STAIRS_VANILLA_FIREPROOF.getFeatureByType().entrySet()) {
            this.addStair((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.SLABS.getFeatureByType().entrySet()) {
            this.addSlab((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.SLABS_FIREPROOF.getFeatureByType().entrySet()) {
            this.addSlab((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.SLABS_VANILLA_FIREPROOF.getFeatureByType().entrySet()) {
            this.addSlab((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.FENCES.getFeatureByType().entrySet()) {
            this.addFence((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.FENCES_FIREPROOF.getFeatureByType().entrySet()) {
            this.addFence((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.FENCES_VANILLA_FIREPROOF.getFeatureByType().entrySet()) {
            this.addFence((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.FENCE_GATES.getFeatureByType().entrySet()) {
            this.addFenceGate((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.FENCE_GATES_FIREPROOF.getFeatureByType().entrySet()) {
            this.addFenceGate((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.FENCE_GATES_VANILLA_FIREPROOF.getFeatureByType().entrySet()) {
            this.addFenceGate((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (Map.Entry entry : ArboricultureBlocks.DOORS.getFeatureByType().entrySet()) {
            this.addDoor((FeatureBlock)entry.getValue(), (IWoodType)entry.getKey());
        }
        for (BlockDecorativeLeaves blockDecorativeLeaves : ArboricultureBlocks.LEAVES_DECORATIVE.getBlocks()) {
            this.addVariants(blockDecorativeLeaves, new BlockStateProvider.Builder().always(variant -> variant.model("forestry:block/leaves")));
        }
        for (BlockDefaultLeavesFruit blockDefaultLeavesFruit : ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.getBlocks()) {
            this.addVariants((Block)blockDefaultLeavesFruit, new BlockStateProvider.Builder().always(variant -> variant.model("forestry:block/leaves")).alwaysIgnore(new Property[]{LeavesBlock.field_208494_a, LeavesBlock.field_208495_b}));
        }
        for (BlockDefaultLeaves blockDefaultLeaves : ArboricultureBlocks.LEAVES_DEFAULT.getBlocks()) {
            this.addVariants((Block)blockDefaultLeaves, new BlockStateProvider.Builder().always(variant -> variant.model("forestry:block/leaves")).alwaysIgnore(new Property[]{LeavesBlock.field_208494_a, LeavesBlock.field_208495_b}));
        }
    }

    private String getLocation(IWoodType type, WoodBlockKind kind) {
        String location;
        if (type instanceof EnumVanillaWoodType) {
            location = "block/" + type.func_176610_l() + "_" + kind.func_176610_l();
        } else {
            String kindName = kind.func_176610_l();
            if (!kindName.endsWith("s")) {
                kindName = kindName + "s";
            }
            location = "forestry:block/arboriculture/" + kindName + "/" + type.func_176610_l();
        }
        return location;
    }

    private void addPlank(FeatureBlock<? extends Block, BlockItem> feature, IWoodType type) {
        this.addVariants((Block)feature.block(), new BlockStateProvider.Builder().always(variant -> variant.model(this.getLocation(type, WoodBlockKind.PLANKS))));
    }

    private void addLog(FeatureBlock<? extends Block, BlockItem> feature, IWoodType type) {
        this.addVariants((Block)feature.block(), new BlockStateProvider.Builder().always(variant -> variant.model(this.getLocation(type, WoodBlockKind.LOG))).property(BlockStateProperties.field_208148_A, Direction.Axis.X, variant -> variant.rotationX(90).rotationY(90)).property(BlockStateProperties.field_208148_A, Direction.Axis.Z, variant -> variant.rotationX(90)));
    }

    private void addStair(FeatureBlock<? extends Block, BlockItem> feature, IWoodType type) {
        String modelLocation = this.getLocation(type, WoodBlockKind.STAIRS);
        BlockState defaultState = feature.defaultState();
        this.addVariants((Block)feature.block(), new BlockStateProvider.Builder().alwaysIgnore(new Property[]{StairsBlock.field_204513_t}).always(variant -> variant.lock(true)).property(StairsBlock.field_176308_b, Half.TOP, variant -> variant.rotationX(180)).property(StairsBlock.field_176310_M, StairsShape.INNER_LEFT, variant -> variant.model(modelLocation + "_inner")).property(StairsBlock.field_176310_M, StairsShape.INNER_RIGHT, variant -> variant.model(modelLocation + "_inner")).property(StairsBlock.field_176310_M, StairsShape.OUTER_LEFT, variant -> variant.model(modelLocation + "_outer")).property(StairsBlock.field_176310_M, StairsShape.OUTER_RIGHT, variant -> variant.model(modelLocation + "_outer")).property(StairsBlock.field_176310_M, StairsShape.STRAIGHT, variant -> variant.model(modelLocation)).property(StairsBlock.field_176309_a, Direction.WEST, variant -> variant.rotationY(180)).property(StairsBlock.field_176309_a, Direction.SOUTH, variant -> variant.rotationY(90)).property(StairsBlock.field_176309_a, Direction.NORTH, variant -> variant.rotationY(270)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.BOTTOM)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_LEFT), variant -> variant.rotationY(270)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.WEST)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.BOTTOM)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_LEFT), variant -> variant.rotationY(90)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.BOTTOM)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_LEFT), variant -> variant.rotationY(0)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.NORTH)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.BOTTOM)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_LEFT), variant -> variant.rotationY(180)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.BOTTOM)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_LEFT), variant -> variant.rotationY(270)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.WEST)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.BOTTOM)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_LEFT), variant -> variant.rotationY(90)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.BOTTOM)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_LEFT), variant -> variant.rotationY(0)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.NORTH)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.BOTTOM)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_LEFT), variant -> variant.rotationY(180)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_RIGHT), variant -> variant.rotationY(90)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.WEST)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_RIGHT), variant -> variant.rotationY(270)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_RIGHT), variant -> variant.rotationY(180)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.NORTH)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_RIGHT), variant -> variant.rotationY(0)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_RIGHT), variant -> variant.rotationY(90)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.WEST)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_RIGHT), variant -> variant.rotationY(270)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_RIGHT), variant -> variant.rotationY(180)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.NORTH)).func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP)).func_206870_a((Property)StairsBlock.field_176310_M, (Comparable)StairsShape.INNER_RIGHT), variant -> variant.rotationY(0)));
    }

    private void addSlab(FeatureBlock<? extends Block, BlockItem> feature, IWoodType type) {
        String modelLocation = this.getLocation(type, WoodBlockKind.SLAB);
        String plankLocation = type instanceof EnumVanillaWoodType ? "block/" + type.func_176610_l() + "_planks" : "forestry:block/arboriculture/planks/" + type.func_176610_l();
        this.addVariants((Block)feature.block(), new BlockStateProvider.Builder().alwaysIgnore(new Property[]{SlabBlock.field_204512_b}).property(SlabBlock.field_196505_a, SlabType.TOP, variant -> variant.model(modelLocation + "_top")).property(SlabBlock.field_196505_a, SlabType.BOTTOM, variant -> variant.model(modelLocation)).property(SlabBlock.field_196505_a, SlabType.DOUBLE, variant -> variant.model(plankLocation)));
    }

    private void addFence(FeatureBlock<? extends Block, BlockItem> feature, IWoodType type) {
        String modelLocation = this.getLocation(type, WoodBlockKind.FENCE);
        this.addVariants((Block)feature.block(), new BlockStateProvider.MultipartBuilder().always(variant -> variant.model(modelLocation + (type instanceof EnumVanillaWoodType ? "_post" : ""))).property(variant -> variant.model(modelLocation + "_side").lock(true), (Property)FourWayBlock.field_196409_a, new Boolean[]{true}).property(variant -> variant.model(modelLocation + "_side").lock(true).rotationY(90), (Property)FourWayBlock.field_196411_b, new Boolean[]{true}).property(variant -> variant.model(modelLocation + "_side").lock(true).rotationY(180), (Property)FourWayBlock.field_196413_c, new Boolean[]{true}).property(variant -> variant.model(modelLocation + "_side").lock(true).rotationY(270), (Property)FourWayBlock.field_196414_y, new Boolean[]{true}));
    }

    private void addFenceGate(FeatureBlock<? extends Block, BlockItem> feature, IWoodType type) {
        String modelLocation = this.getLocation(type, WoodBlockKind.FENCE_GATE);
        this.addVariants((Block)feature.block(), new BlockStateProvider.Builder().always(variant -> variant.lock(true)).alwaysIgnore(new Property[]{FenceGateBlock.field_176465_b}).property(HorizontalBlock.field_185512_D, Direction.WEST, variant -> variant.rotationY(90)).property(HorizontalBlock.field_185512_D, Direction.EAST, variant -> variant.rotationY(270)).property(HorizontalBlock.field_185512_D, Direction.NORTH, variant -> variant.rotationY(180)).property(FenceGateBlock.field_176467_M, false, FenceGateBlock.field_176466_a, false, variant -> variant.model(modelLocation)).property(FenceGateBlock.field_176467_M, false, FenceGateBlock.field_176466_a, true, variant -> variant.model(modelLocation + "_open")).property(FenceGateBlock.field_176467_M, true, FenceGateBlock.field_176466_a, false, variant -> variant.model(modelLocation + "_wall")).property(FenceGateBlock.field_176467_M, true, FenceGateBlock.field_176466_a, true, variant -> variant.model(modelLocation + "_wall_open")));
    }

    private void addDoor(FeatureBlock<? extends Block, BlockItem> feature, IWoodType type) {
        String modelLocation = this.getLocation(type, WoodBlockKind.DOOR);
        BlockState defaultState = feature.block().func_176223_P();
        this.addVariants((Block)feature.block(), new BlockStateProvider.Builder().alwaysIgnore(new Property[]{DoorBlock.field_176522_N}).property(DoorBlock.field_176520_a, Direction.SOUTH, variant -> variant.rotationY(90)).property(DoorBlock.field_176520_a, Direction.WEST, variant -> variant.rotationY(180)).property(DoorBlock.field_176520_a, Direction.NORTH, variant -> variant.rotationY(270)).push().ignore((Property<?>)DoorBlock.field_176523_O).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)Direction.EAST)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true)), variant -> variant.rotationY(90)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)Direction.SOUTH)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true)), variant -> variant.rotationY(180)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)Direction.WEST)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true)), variant -> variant.rotationY(270)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)Direction.NORTH)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true)), variant -> variant.rotationY(0)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)Direction.EAST)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.RIGHT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true)), variant -> variant.rotationY(270)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)Direction.SOUTH)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.RIGHT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true)), variant -> variant.rotationY(0)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)Direction.WEST)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.RIGHT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true)), variant -> variant.rotationY(90)).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)Direction.NORTH)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.RIGHT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true)), variant -> variant.rotationY(180)).popIgnore().push().ignore((Property<?>)DoorBlock.field_176520_a).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(false)), variant -> variant.model(modelLocation + "_bottom")).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.RIGHT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true)), variant -> variant.model(modelLocation + "_bottom")).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.RIGHT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(false)), variant -> variant.model(modelLocation + "_bottom_hinge")).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true)), variant -> variant.model(modelLocation + "_bottom_hinge")).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(false)), variant -> variant.model(modelLocation + "_top")).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.RIGHT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true)), variant -> variant.model(modelLocation + "_top")).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.RIGHT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(false)), variant -> variant.model(modelLocation + "_top_hinge")).state((BlockState)((BlockState)((BlockState)defaultState.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(true)), variant -> variant.model(modelLocation + "_top_hinge")));
    }
}

