/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.core.data.ModelProvider;
import forestry.modules.features.FeatureBlock;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class WoodItemModelProvider
extends ModelProvider {
    public WoodItemModelProvider(DataGenerator generator) {
        super(generator, "item");
    }

    @Override
    protected void registerModels() {
        for (Map.Entry stair : ArboricultureBlocks.PLANKS.getFeatureByType().entrySet()) {
            this.addPlank((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.PLANKS_FIREPROOF.getFeatureByType().entrySet()) {
            this.addPlank((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.PLANKS_VANILLA_FIREPROOF.getFeatureByType().entrySet()) {
            this.addPlank((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.LOGS.getFeatureByType().entrySet()) {
            this.addLog((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.LOGS_FIREPROOF.getFeatureByType().entrySet()) {
            this.addLog((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.LOGS_VANILLA_FIREPROOF.getFeatureByType().entrySet()) {
            this.addLog((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.STAIRS.getFeatureByType().entrySet()) {
            this.addStair((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.STAIRS_FIREPROOF.getFeatureByType().entrySet()) {
            this.addStair((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.STAIRS_VANILLA_FIREPROOF.getFeatureByType().entrySet()) {
            this.addStair((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.SLABS.getFeatureByType().entrySet()) {
            this.addSlab((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.SLABS_FIREPROOF.getFeatureByType().entrySet()) {
            this.addSlab((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.SLABS_VANILLA_FIREPROOF.getFeatureByType().entrySet()) {
            this.addSlab((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.FENCES.getFeatureByType().entrySet()) {
            this.addFence((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.FENCES_FIREPROOF.getFeatureByType().entrySet()) {
            this.addFence((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.FENCES_VANILLA_FIREPROOF.getFeatureByType().entrySet()) {
            this.addFence((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.FENCE_GATES.getFeatureByType().entrySet()) {
            this.addFenceGate((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.FENCE_GATES_FIREPROOF.getFeatureByType().entrySet()) {
            this.addFenceGate((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.FENCE_GATES_VANILLA_FIREPROOF.getFeatureByType().entrySet()) {
            this.addFenceGate((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (Map.Entry stair : ArboricultureBlocks.DOORS.getFeatureByType().entrySet()) {
            this.addDoor((BlockItem)((FeatureBlock)stair.getValue()).item(), (IWoodType)stair.getKey());
        }
        for (BlockItem leaves : ArboricultureBlocks.LEAVES_DECORATIVE.getItems()) {
            this.registerModel((Item)leaves, new ModelProvider.ModelBuilder().parent(new ResourceLocation("forestry:block/leaves")));
        }
        for (BlockItem leaves : ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.getItems()) {
            this.registerModel((Item)leaves, new ModelProvider.ModelBuilder().parent(new ResourceLocation("forestry:block/leaves")));
        }
        for (BlockItem leaves : ArboricultureBlocks.LEAVES_DEFAULT.getItems()) {
            this.registerModel((Item)leaves, new ModelProvider.ModelBuilder().parent(new ResourceLocation("forestry:block/leaves")));
        }
    }

    private String getLocation(IWoodType type, WoodBlockKind kind) {
        String location;
        if (type instanceof EnumVanillaWoodType) {
            location = "block/" + type.func_176610_l() + "_" + kind.func_176610_l();
        } else if (kind == WoodBlockKind.DOOR) {
            location = "forestry:item/doors/" + type.func_176610_l();
        } else {
            String kindName = kind.func_176610_l();
            if (!kindName.endsWith("s")) {
                kindName = kindName + "s";
            }
            location = "forestry:block/arboriculture/" + kindName + "/" + type.func_176610_l();
        }
        return location;
    }

    private void addPlank(BlockItem item, IWoodType type) {
        this.registerModel((Item)item, new ModelProvider.ModelBuilder().parent(new ResourceLocation(this.getLocation(type, WoodBlockKind.PLANKS))));
    }

    private void addLog(BlockItem item, IWoodType type) {
        this.registerModel((Item)item, new ModelProvider.ModelBuilder().parent(new ResourceLocation(this.getLocation(type, WoodBlockKind.LOG))));
    }

    private void addStair(BlockItem item, IWoodType type) {
        this.registerModel((Item)item, new ModelProvider.ModelBuilder().parent(new ResourceLocation(this.getLocation(type, WoodBlockKind.STAIRS))));
    }

    private void addSlab(BlockItem item, IWoodType type) {
        this.registerModel((Item)item, new ModelProvider.ModelBuilder().parent(new ResourceLocation(this.getLocation(type, WoodBlockKind.SLAB))));
    }

    private void addFence(BlockItem item, IWoodType type) {
        this.registerModel((Item)item, new ModelProvider.ModelBuilder().parent(new ResourceLocation(this.getLocation(type, WoodBlockKind.FENCE) + "_inventory")));
    }

    private void addFenceGate(BlockItem item, IWoodType type) {
        this.registerModel((Item)item, new ModelProvider.ModelBuilder().parent(new ResourceLocation(this.getLocation(type, WoodBlockKind.FENCE_GATE))));
    }

    private void addDoor(BlockItem item, IWoodType type) {
        this.registerModel((Item)item, new ModelProvider.ModelBuilder().item().layer(0, new ResourceLocation(this.getLocation(type, WoodBlockKind.DOOR))));
    }
}

