/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.recipes.IFermenterRecipe;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FermenterRecipeBuilder {
    private Ingredient resource;
    private int fermentationValue;
    private float modifier;
    private Fluid output;
    private FluidStack fluidResource;

    public FermenterRecipeBuilder setResource(Ingredient resource) {
        this.resource = resource;
        return this;
    }

    public FermenterRecipeBuilder setFermentationValue(int fermentationValue) {
        this.fermentationValue = fermentationValue;
        return this;
    }

    public FermenterRecipeBuilder setModifier(float modifier) {
        this.modifier = modifier;
        return this;
    }

    public FermenterRecipeBuilder setOutput(Fluid output) {
        this.output = output;
        return this;
    }

    public FermenterRecipeBuilder setFluidResource(FluidStack fluidResource) {
        this.fluidResource = fluidResource;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.resource, this.fermentationValue, this.modifier, this.output, this.fluidResource));
    }

    private static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient resource;
        private final int fermentationValue;
        private final float modifier;
        private final Fluid output;
        private final FluidStack fluidResource;

        public Result(ResourceLocation id, Ingredient resource, int fermentationValue, float modifier, Fluid output, FluidStack fluidResource) {
            this.id = id;
            this.resource = resource;
            this.fermentationValue = fermentationValue;
            this.modifier = modifier;
            this.output = output;
            this.fluidResource = fluidResource;
        }

        public void func_218610_a(JsonObject json) {
            json.add("resource", this.resource.func_200304_c());
            json.addProperty("fermentationValue", (Number)this.fermentationValue);
            json.addProperty("modifier", (Number)Float.valueOf(this.modifier));
            json.addProperty("output", this.output.getRegistryName().toString());
            json.add("fluidResource", (JsonElement)RecipeSerializers.serializeFluid(this.fluidResource));
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IFermenterRecipe.Companion.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

