/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.recipes.IHygroregulatorRecipe;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class HygroregulatorRecipeBuilder {
    private FluidStack liquid;
    private int transferTime;
    private float humidChange;
    private float tempChange;

    public HygroregulatorRecipeBuilder setLiquid(FluidStack liquid) {
        this.liquid = liquid;
        return this;
    }

    public HygroregulatorRecipeBuilder setTransferTime(int transferTime) {
        this.transferTime = transferTime;
        return this;
    }

    public HygroregulatorRecipeBuilder setHumidChange(float humidChange) {
        this.humidChange = humidChange;
        return this;
    }

    public HygroregulatorRecipeBuilder setTempChange(float tempChange) {
        this.tempChange = tempChange;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.liquid, this.transferTime, this.humidChange, this.tempChange));
    }

    private static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final FluidStack liquid;
        private final int transferTime;
        private final float humidChange;
        private final float tempChange;

        public Result(ResourceLocation id, FluidStack liquid, int transferTime, float humidChange, float tempChange) {
            this.id = id;
            this.liquid = liquid;
            this.transferTime = transferTime;
            this.humidChange = humidChange;
            this.tempChange = tempChange;
        }

        public void func_218610_a(JsonObject json) {
            json.add("liquid", (JsonElement)RecipeSerializers.serializeFluid(this.liquid));
            json.addProperty("time", (Number)this.transferTime);
            json.addProperty("humidChange", (Number)Float.valueOf(this.humidChange));
            json.addProperty("tempChange", (Number)Float.valueOf(this.tempChange));
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IHygroregulatorRecipe.Companion.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

