/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import forestry.core.data.builder.Holder;
import forestry.core.recipes.ModuleEnabledCondition;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class RecipeDataHelper {
    private final Consumer<IFinishedRecipe> consumer;

    public RecipeDataHelper(Consumer<IFinishedRecipe> consumer) {
        this.consumer = consumer;
    }

    public Consumer<IFinishedRecipe> getConsumer() {
        return this.consumer;
    }

    public void simpleConditionalRecipe(Consumer<Consumer<IFinishedRecipe>> recipe, ICondition ... conditions) {
        this.simpleConditionalRecipe(recipe, (ResourceLocation)null, conditions);
    }

    public void simpleConditionalRecipe(Consumer<Consumer<IFinishedRecipe>> recipe, @Nullable ResourceLocation id, ICondition ... conditions) {
        ConditionalRecipe.Builder builder = ConditionalRecipe.builder();
        for (ICondition condition : conditions) {
            builder.addCondition(condition);
        }
        Holder finishedRecipeHolder = new Holder();
        recipe.accept(finishedRecipeHolder::set);
        IFinishedRecipe finishedRecipe = (IFinishedRecipe)finishedRecipeHolder.get();
        builder.addRecipe(finishedRecipe);
        builder.build(this.consumer, id == null ? finishedRecipe.func_200442_b() : id);
    }

    public void moduleConditionRecipe(Consumer<Consumer<IFinishedRecipe>> recipe, @Nullable ResourceLocation id, String ... moduleUIDs) {
        this.simpleConditionalRecipe(recipe, id, (ICondition[])Arrays.stream(moduleUIDs).map(u -> new ModuleEnabledCondition("forestry", (String)u)).toArray(ICondition[]::new));
    }

    public void moduleConditionRecipe(Consumer<Consumer<IFinishedRecipe>> recipe, String ... moduleUIDs) {
        this.moduleConditionRecipe(recipe, (ResourceLocation)null, moduleUIDs);
    }
}

