/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.recipes.IStillRecipe;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class StillRecipeBuilder {
    private int timePerUnit;
    private FluidStack input;
    private FluidStack output;

    public StillRecipeBuilder setTimePerUnit(int timePerUnit) {
        this.timePerUnit = timePerUnit;
        return this;
    }

    public StillRecipeBuilder setInput(FluidStack input) {
        this.input = input;
        return this;
    }

    public StillRecipeBuilder setOutput(FluidStack output) {
        this.output = output;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.timePerUnit, this.input, this.output));
    }

    private static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final int timePerUnit;
        private final FluidStack input;
        private final FluidStack output;

        public Result(ResourceLocation id, int timePerUnit, FluidStack input, FluidStack output) {
            this.id = id;
            this.timePerUnit = timePerUnit;
            this.input = input;
            this.output = output;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("time", (Number)this.timePerUnit);
            json.add("input", (JsonElement)RecipeSerializers.serializeFluid(this.input));
            json.add("output", (JsonElement)RecipeSerializers.serializeFluid(this.output));
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IStillRecipe.Companion.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

