/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.entities;

import forestry.core.tiles.ITitled;
import forestry.core.utils.PlayerUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class MinecartEntityForestry
extends AbstractMinecartEntity
implements ITitled {
    public MinecartEntityForestry(EntityType<? extends MinecartEntityForestry> type, World world) {
        super(type, world);
        this.func_94096_e(true);
    }

    public MinecartEntityForestry(EntityType<?> type, World world, double posX, double posY, double posZ) {
        super(type, world, posX, posY, posZ);
        this.func_94096_e(true);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ActionResultType ret = super.func_184230_a(player, hand);
        if (ret.func_226246_a_()) {
            return ret;
        }
        PlayerUtil.actOnServer(player, this::openGui);
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    protected abstract void openGui(ServerPlayerEntity var1);

    public boolean canBeRidden() {
        return false;
    }

    public boolean isPoweredCart() {
        return false;
    }

    public abstract BlockState func_174897_t();

    public abstract ItemStack getCartItem();

    public void func_94095_a(DamageSource damageSource) {
        super.func_94095_a(damageSource);
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            Block block = this.func_174897_t().func_177230_c();
            this.func_70099_a(new ItemStack((IItemProvider)block), 0.0f);
        }
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent(this.getUnlocalizedTitle());
    }

    @Override
    public String getUnlocalizedTitle() {
        ItemStack cartItem = this.getCartItem();
        return cartItem.func_77977_a();
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return null;
    }
}

