/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.modules.features.FeatureFluid;
import forestry.modules.features.FluidProperties;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockForestryFluid
extends FlowingFluidBlock {
    private final FeatureFluid feature;
    private final boolean flammable;
    private final int flammability;
    private final Color color;

    public BlockForestryFluid(FeatureFluid feature) {
        super(feature::fluid, AbstractBlock.Properties.func_200945_a((Material)(feature.fluid().getAttributes().getTemperature() > 505 ? Material.field_151587_i : Material.field_151586_h)).func_200942_a().func_200943_b(100.0f).func_222380_e());
        this.feature = feature;
        FluidProperties properties = feature.properties();
        this.flammability = properties.flammability;
        this.flammable = properties.flammable;
        this.color = properties.particleColor;
    }

    public void func_225542_b_(BlockState blockState, ServerWorld world, BlockPos pos, Random rand) {
        Material material;
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        if (this.field_149764_J == Material.field_151586_h) {
            int i = (Integer)blockState.func_177229_b((Property)field_176367_b);
            if (i > 0 && i < 8) {
                if (this.getFluid().getAttributes().getViscosity((IBlockDisplayReader)world, pos) < 5000 && rand.nextInt(64) == 0) {
                    world.func_184134_a(x + 0.5, y + 0.5, z + 0.5, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, rand.nextFloat() * 0.25f + 0.75f, rand.nextFloat() + 0.5f, false);
                }
            } else if (rand.nextInt(10) == 0) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197605_P, x + (double)rand.nextFloat(), y + (double)rand.nextFloat(), z + (double)rand.nextFloat(), 0.0, 0.0, 0.0);
            }
        }
        if (this.field_149764_J == Material.field_151587_i && world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && !world.func_180495_p(pos.func_177984_a()).func_200015_d((IBlockReader)world, pos.func_177984_a())) {
            if (rand.nextInt(100) == 0) {
                double d8 = x + (double)rand.nextFloat();
                double d4 = y + 1.0;
                double d6 = z + (double)rand.nextFloat();
                world.func_195594_a((IParticleData)ParticleTypes.field_197595_F, d8, d4, d6, 0.0, 0.0, 0.0);
                world.func_184134_a(d8, d4, d6, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(200) == 0) {
                world.func_184134_a(x, y, z, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        }
        if (rand.nextInt(10) == 0 && Block.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177977_b(), (Direction)Direction.DOWN) && !(material = world.func_180495_p(pos.func_177979_c(2)).func_185904_a()).func_76230_c() && !material.func_76224_d()) {
            double px = x + (double)rand.nextFloat();
            double py = y - 1.05;
            double d = z + (double)rand.nextFloat();
        }
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.flammable ? 30 : 0;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.flammability;
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.flammable;
    }

    private static boolean isFlammable(IBlockReader world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        return blockState.isFlammable(world, pos, Direction.UP);
    }

    public boolean isFireSource(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return this.flammable && this.flammability == 0;
    }

    public Color getColor() {
        return this.color;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        float explosionSize;
        int flammability;
        super.func_225534_a_(state, world, pos, rand);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (this.field_149764_J == Material.field_151587_i) {
            int rangeUp = rand.nextInt(3);
            for (int i = 0; i < rangeUp; ++i) {
                BlockState blockState = world.func_180495_p(new BlockPos(x += rand.nextInt(3) - 1, ++y, z += rand.nextInt(3) - 1));
                if (blockState.func_185904_a() == Material.field_151579_a) {
                    if (!BlockForestryFluid.isNeighborFlammable((World)world, x, y, z)) continue;
                    world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150480_ab.func_176223_P());
                    return;
                }
                if (!blockState.func_185904_a().func_76230_c()) continue;
                return;
            }
            if (rangeUp == 0) {
                int startX = x;
                int startZ = z;
                for (int i = 0; i < 3; ++i) {
                    x = startX + rand.nextInt(3) - 1;
                    z = startZ + rand.nextInt(3) - 1;
                    BlockPos posAbove = new BlockPos(pos.func_177958_n(), y + 1, z);
                    if (!world.func_175623_d(posAbove) || !BlockForestryFluid.isFlammable((IBlockReader)world, new BlockPos(x, y, z))) continue;
                    world.func_175656_a(posAbove, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
        if ((flammability = this.getFlammability(state, (IBlockReader)world, pos, null)) > 0 && (double)(explosionSize = 4.0f * (float)flammability / 300.0f) > 1.0 && BlockForestryFluid.isNearFire((World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            world.func_217398_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), explosionSize, true, Explosion.Mode.DESTROY);
        }
    }

    private static boolean isNeighborFlammable(World world, int x, int y, int z) {
        return BlockForestryFluid.isFlammable((IBlockReader)world, new BlockPos(x - 1, y, z)) || BlockForestryFluid.isFlammable((IBlockReader)world, new BlockPos(x + 1, y, z)) || BlockForestryFluid.isFlammable((IBlockReader)world, new BlockPos(x, y, z - 1)) || BlockForestryFluid.isFlammable((IBlockReader)world, new BlockPos(x, y, z + 1)) || BlockForestryFluid.isFlammable((IBlockReader)world, new BlockPos(x, y - 1, z)) || BlockForestryFluid.isFlammable((IBlockReader)world, new BlockPos(x, y + 1, z));
    }

    private static boolean isNearFire(World world, int x, int y, int z) {
        AxisAlignedBB boundingBox = new AxisAlignedBB((double)(x - 1), (double)(y - 1), (double)(z - 1), (double)(x + 1), (double)(y + 1), (double)(z + 1));
        return BlockPos.func_239581_a_((AxisAlignedBB)boundingBox.func_186664_h(0.001)).noneMatch(pos -> {
            BlockState state = world.func_180495_p(pos);
            return state.func_235714_a_((ITag)BlockTags.field_232872_am_) || state.func_203425_a(Blocks.field_150353_l) || state.isBurning((IBlockReader)world, pos);
        });
    }
}

