/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.fluids.FluidHelper;
import forestry.core.utils.ItemStackUtil;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ContainerFiller {
    private final FluidTank fluidTank;
    private final int fillingTime;
    private final IInventory inventory;
    private final int inputSlot;
    private final int outputSlot;
    @Nullable
    private ItemStack usedInput;
    private int fillingProgress;

    public ContainerFiller(FluidTank fluidTank, int fillingTime, IInventory inventory, int inputSlot, int outputSlot) {
        this.fluidTank = fluidTank;
        this.fillingTime = fillingTime;
        this.inventory = inventory;
        this.inputSlot = inputSlot;
        this.outputSlot = outputSlot;
    }

    public void updateServerSide() {
        FluidStack tankContents;
        ItemStack input = this.inventory.func_70301_a(this.inputSlot);
        if (this.usedInput == null || !ItemStackUtil.isIdenticalItem(this.usedInput, input)) {
            this.fillingProgress = 0;
            this.usedInput = input;
        }
        if (this.usedInput != null && !(tankContents = this.fluidTank.getFluid()).isEmpty() && tankContents.getAmount() > 0) {
            if (this.fillingProgress == 0) {
                Fluid tankFluid = tankContents.getFluid();
                FluidHelper.FillStatus canFill = FluidHelper.fillContainers((IFluidHandler)this.fluidTank, this.inventory, this.inputSlot, this.outputSlot, tankFluid, false);
                if (canFill == FluidHelper.FillStatus.SUCCESS) {
                    this.fillingProgress = 1;
                }
            } else {
                Fluid tankFluid;
                FluidHelper.FillStatus filled;
                ++this.fillingProgress;
                if (this.fillingProgress >= this.fillingTime && (filled = FluidHelper.fillContainers((IFluidHandler)this.fluidTank, this.inventory, this.inputSlot, this.outputSlot, tankFluid = tankContents.getFluid(), true)) == FluidHelper.FillStatus.SUCCESS) {
                    this.fillingProgress = 0;
                }
            }
        }
    }

    public int getFillingProgress() {
        return this.fillingProgress;
    }
}

