/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import com.google.common.base.Suppliers;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.fluids.StandardTank;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FilteredTank
extends StandardTank {
    private Supplier<Set<ResourceLocation>> filters = Suppliers.ofInstance(new HashSet());

    public FilteredTank(int capacity) {
        super(capacity);
        this.setValidator(this::fluidMatchesFilter);
    }

    public FilteredTank(int capacity, boolean canFill, boolean canDrain) {
        super(capacity, canFill, canDrain);
    }

    public FilteredTank setFilters(Supplier<Set<ResourceLocation>> filters) {
        this.filters = filters;
        return this;
    }

    public FilteredTank setFilters(Fluid ... filters) {
        return this.setFilters(Arrays.asList(filters));
    }

    public FilteredTank setFilters(Collection<Fluid> filters) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        this.filters = () -> set;
        for (Fluid fluid : filters) {
            set.add(fluid.getRegistryName());
        }
        return this;
    }

    private boolean fluidMatchesFilter(FluidStack resource) {
        return resource.getFluid() != Fluids.field_204541_a && this.filters.get().contains(resource.getFluid().getRegistryName());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void refreshTooltip() {
        if (this.hasFluid()) {
            super.refreshTooltip();
            return;
        }
        ToolTip toolTip = this.getToolTip();
        toolTip.clear();
        Set<ResourceLocation> filters = this.filters.get();
        if (Screen.func_231173_s_() || filters.size() < 5) {
            for (ResourceLocation filterName : filters) {
                Fluid fluidFilter = (Fluid)ForgeRegistries.FLUIDS.getValue(filterName);
                FluidAttributes attributes = fluidFilter.getAttributes();
                Rarity rarity = attributes.getRarity();
                if (rarity == null) {
                    rarity = Rarity.COMMON;
                }
                FluidStack filterFluidStack = new FluidStack(fluidFilter, 1);
                toolTip.add(filterFluidStack.getDisplayName(), rarity.field_77937_e);
            }
        } else {
            IFormattableTextComponent tmiComponent = new StringTextComponent("<").func_230529_a_((ITextComponent)new TranslationTextComponent("for.gui.tooltip.tmi")).func_230529_a_((ITextComponent)new StringTextComponent(">"));
            toolTip.add((ITextComponent)tmiComponent, TextFormatting.ITALIC);
        }
        toolTip.add((ITextComponent)new TranslationTextComponent("for.gui.tooltip.liquid.amount", new Object[]{this.getFluidAmount(), this.getCapacity()}));
    }
}

