/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.utils.ItemStackUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;

public final class FluidHelper {
    private FluidHelper() {
    }

    public static boolean areFluidStacksEqual(@Nullable FluidStack fluidStack1, @Nullable FluidStack fluidStack2) {
        if (fluidStack1 == null) {
            return fluidStack2 == null;
        }
        return fluidStack1.isFluidStackIdentical(fluidStack2);
    }

    public static boolean canAcceptFluid(World world, BlockPos pos, Direction facing, FluidStack fluid, boolean checkSpace) {
        LazyOptional capability = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (Direction)facing);
        return capability.filter(handler -> {
            for (int tank = 0; tank < handler.getTanks(); ++tank) {
                int amountFilled = handler.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
                if (amountFilled <= 0 || checkSpace && amountFilled < fluid.getAmount()) continue;
                return true;
            }
            return false;
        }).isPresent();
    }

    public static boolean canAcceptFluid(World world, BlockPos pos, Direction facing, FluidStack fluid) {
        return FluidHelper.canAcceptFluid(world, pos, facing, fluid, false);
    }

    public static FillStatus fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean doFill) {
        return FluidHelper.fillContainers(fluidHandler, inv, inputSlot, outputSlot, fluidToFill, FluidHelper.getEmptyContainer(inv.func_70301_a(inputSlot)), doFill);
    }

    public static FillStatus fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, ItemStack emptyStack, boolean doFill) {
        boolean moveToOutput;
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input.func_190926_b()) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack output = inv.func_70301_a(outputSlot);
        ItemStack filled = input.func_77946_l();
        filled.func_190920_e(1);
        if (emptyStack.func_190926_b()) {
            emptyStack = filled;
        }
        LazyOptional fluidFilledHandlerCap = FluidUtil.getFluidHandler((ItemStack)filled);
        LazyOptional fluidEmptyHandlerCap = FluidUtil.getFluidHandler((ItemStack)emptyStack);
        if (!fluidFilledHandlerCap.isPresent() || !fluidEmptyHandlerCap.isPresent()) {
            return FillStatus.INVALID_INPUT;
        }
        IFluidHandlerItem fluidFilledHandler = (IFluidHandlerItem)fluidFilledHandlerCap.orElse(null);
        IFluidHandlerItem fluidEmptyHandler = (IFluidHandlerItem)fluidEmptyHandlerCap.orElse(null);
        int containerEmptyCapacity = fluidEmptyHandler.fill(new FluidStack(fluidToFill, Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
        int containerCapacity = fluidFilledHandler.fill(new FluidStack(fluidToFill, Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
        if (containerCapacity <= 0 && containerEmptyCapacity <= 0) {
            return FillStatus.INVALID_INPUT;
        }
        FluidStack canDrain = fluidHandler.drain(new FluidStack(fluidToFill, containerCapacity), IFluidHandler.FluidAction.SIMULATE);
        if (canDrain.isEmpty()) {
            return FillStatus.NO_FLUID;
        }
        if (fluidFilledHandler.fill(canDrain, IFluidHandler.FluidAction.EXECUTE) <= 0) {
            return FillStatus.NO_FLUID;
        }
        FluidStack fluidInContainer = fluidFilledHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (fluidInContainer.isEmpty()) {
            return FillStatus.INVALID_INPUT;
        }
        filled = fluidFilledHandler.getContainer();
        boolean bl = moveToOutput = fluidInContainer.getAmount() >= containerCapacity;
        if (moveToOutput ? !output.func_190926_b() && (output.func_190916_E() >= output.func_77976_d() || !ItemStackUtil.areItemStacksEqualIgnoreCount(filled, output)) : input.func_190916_E() > 1) {
            return FillStatus.NO_SPACE;
        }
        if (doFill) {
            fluidHandler.drain(canDrain, IFluidHandler.FluidAction.EXECUTE);
            if (moveToOutput) {
                if (output.func_190926_b()) {
                    inv.func_70299_a(outputSlot, filled);
                } else {
                    output.func_190917_f(1);
                }
                inv.func_70298_a(inputSlot, 1);
            } else {
                inv.func_70299_a(inputSlot, filled);
            }
        }
        return FillStatus.SUCCESS;
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot) {
        FluidActionResult fluidActionResult;
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input.func_190926_b()) {
            return false;
        }
        FluidActionResult fluidActionSimulated = FluidHelper.tryEmptyContainer(input, fluidHandler, 1000, null, false);
        if (!fluidActionSimulated.isSuccess()) {
            return false;
        }
        ItemStack drainedItemSimulated = fluidActionSimulated.getResult();
        if ((input.func_190916_E() == 1 || drainedItemSimulated.func_190926_b()) && (fluidActionResult = FluidHelper.tryEmptyContainer(input, fluidHandler, 1000, null, true)).isSuccess()) {
            ItemStack drainedItem = fluidActionResult.getResult();
            if (!drainedItem.func_190926_b()) {
                inv.func_70299_a(inputSlot, drainedItem);
            } else {
                inv.func_70298_a(inputSlot, 1);
            }
            return true;
        }
        return false;
    }

    public static FillStatus drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, boolean doDrain) {
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input.func_190926_b()) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack outputStack = inv.func_70301_a(outputSlot);
        FluidStack content = FluidUtil.getFluidContained((ItemStack)input).orElse(FluidStack.EMPTY);
        FluidActionResult drainedResultSimulated = FluidHelper.tryEmptyContainer(input, fluidHandler, 1000, null, false);
        if (!drainedResultSimulated.isSuccess()) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack drainedItemSimulated = drainedResultSimulated.getResult();
        if (outputStack.func_190926_b() || drainedItemSimulated.func_190926_b() || ItemStackUtil.isIdenticalItem(outputStack, drainedItemSimulated) && outputStack.func_190916_E() + drainedItemSimulated.func_190916_E() < outputStack.func_77976_d()) {
            FluidActionResult drainedResult;
            if (doDrain && (drainedResult = FluidHelper.tryEmptyContainer(input, fluidHandler, 1000, null, true)).isSuccess()) {
                ItemStack drainedItem = drainedResult.getResult();
                if (!drainedItem.func_190926_b()) {
                    ItemStack newStack = drainedItem.func_77946_l();
                    if (!outputStack.func_190926_b()) {
                        newStack.func_190917_f(outputStack.func_190916_E());
                    }
                    if (!FluidHelper.isFillableContainer(newStack, content) || FluidHelper.isFillableContainerAndEmpty(newStack, content)) {
                        inv.func_70299_a(outputSlot, newStack);
                        inv.func_70298_a(inputSlot, 1);
                    }
                    if (FluidHelper.isDrainableContainer(newStack) && !FluidHelper.isEmpty(newStack)) {
                        inv.func_70299_a(inputSlot, newStack);
                    }
                } else {
                    inv.func_70298_a(inputSlot, 1);
                }
                return FillStatus.SUCCESS;
            }
            return FillStatus.SUCCESS;
        }
        return FillStatus.NO_SPACE;
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, @Nullable PlayerEntity player, boolean doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return FluidUtil.getFluidHandler((ItemStack)containerCopy).map(containerFluidHandler -> {
            if (doDrain) {
                FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)containerFluidHandler, (int)maxAmount, (boolean)true);
                if (!transfer.isEmpty()) {
                    if (player != null) {
                        SoundEvent soundevent = transfer.getFluid().getAttributes().getEmptySound(transfer);
                        player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    ItemStack resultContainer = containerFluidHandler.getContainer();
                    return new FluidActionResult(resultContainer);
                }
            } else {
                FluidStack simulatedTransfer = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)containerFluidHandler, (int)maxAmount, (boolean)false);
                if (!simulatedTransfer.isEmpty()) {
                    containerFluidHandler.drain(simulatedTransfer, IFluidHandler.FluidAction.EXECUTE);
                    ItemStack resultContainer = containerFluidHandler.getContainer();
                    return new FluidActionResult(resultContainer);
                }
            }
            return FluidActionResult.FAILURE;
        }).orElse(FluidActionResult.FAILURE);
    }

    public static boolean isFillableContainer(ItemStack container, FluidStack content) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        if (!fluidHandlerCap.isPresent()) {
            return false;
        }
        return fluidHandlerCap.filter(handler -> handler.fill(new FluidStack(content, 1), IFluidHandler.FluidAction.SIMULATE) > 0).isPresent();
    }

    public static boolean isFillableContainerAndEmpty(ItemStack container, FluidStack content) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        if (!fluidHandlerCap.isPresent()) {
            return false;
        }
        return fluidHandlerCap.filter(handler -> handler.fill(new FluidStack(content, 1), IFluidHandler.FluidAction.SIMULATE) > 0 && handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).isEmpty()).isPresent();
    }

    public static ItemStack getEmptyContainer(ItemStack container) {
        ItemStack empty = container.func_77946_l();
        empty.func_190920_e(1);
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)empty);
        if (!fluidHandlerCap.isPresent()) {
            return ItemStack.field_190927_a;
        }
        return fluidHandlerCap.filter(fluidHandler -> fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE) != null).isPresent() ? empty : ItemStack.field_190927_a;
    }

    public static boolean isFillableContainerWithRoom(ItemStack container) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        return fluidHandlerCap.isPresent();
    }

    public static boolean isFillableEmptyContainer(ItemStack empty) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)empty);
        return fluidHandlerCap.isPresent();
    }

    public static boolean isDrainableFilledContainer(ItemStack container) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        return fluidHandlerCap.isPresent();
    }

    public static boolean isDrainableContainer(ItemStack container) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        return fluidHandlerCap.isPresent();
    }

    public static boolean isEmpty(ItemStack container) {
        LazyOptional fluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)container);
        if (!fluidHandlerCap.isPresent()) {
            return false;
        }
        return fluidHandlerCap.filter(fluidHandler -> {
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                if (fluidHandler.getFluidInTank(i).isEmpty()) continue;
                return false;
            }
            return true;
        }).isPresent();
    }

    public static enum FillStatus {
        SUCCESS,
        INVALID_INPUT,
        NO_FLUID,
        NO_SPACE,
        NO_SPACE_FLUID;

    }
}

