/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.ModuleFluids;
import forestry.core.items.definitions.DrinkProperties;
import forestry.modules.features.FeatureFluid;
import forestry.modules.features.FeatureItem;
import forestry.modules.features.FeatureProvider;
import forestry.modules.features.ModFeatureRegistry;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

@FeatureProvider
public enum ForestryFluids {
    BIO_ETHANOL(new Color(255, 111, 0), 790, 1000, 300),
    BIOMASS(new Color(100, 132, 41), 400, 6560, 100),
    GLASS(new Color(164, 164, 164), 2400, 10000, 0),
    HONEY(new Color(255, 196, 35), 1420, 75600){

        @Override
        public DrinkProperties getDrinkProperties() {
            return new DrinkProperties(2, 0.2f, 64);
        }
    }
    ,
    ICE(new Color(175, 242, 255), 520, 1000){

        @Override
        public int getTemperature() {
            return 265;
        }
    }
    ,
    JUICE(new Color(168, 201, 114)){

        @Override
        public DrinkProperties getDrinkProperties() {
            return new DrinkProperties(2, 0.2f, 32);
        }
    }
    ,
    MILK(new Color(255, 255, 255), 1030, 3000){

        @Override
        public List<ItemStack> getOtherContainers() {
            return Collections.singletonList(new ItemStack((IItemProvider)Items.field_151117_aB));
        }

        @Override
        protected boolean hasBucket() {
            return false;
        }
    }
    ,
    SEED_OIL(new Color(255, 255, 168), 885, 5000, 2),
    SHORT_MEAD(new Color(239, 154, 56), 1000, 1200, 4){

        @Override
        public DrinkProperties getDrinkProperties() {
            return new DrinkProperties(1, 0.2f, 32);
        }
    };

    private static final Map<ResourceLocation, ForestryFluids> tagToFluid;
    private final ResourceLocation tag;
    private final FeatureFluid feature;
    @Nullable
    private final FeatureItem<BucketItem> bucket;

    private ForestryFluids(Color particleColor) {
        this(particleColor, 1000, 1000);
    }

    private ForestryFluids(Color particleColor, int density, int viscosity) {
        this(particleColor, density, viscosity, -1);
    }

    private ForestryFluids(Color particleColor, int density, int viscosity, int flammability) {
        this.feature = ModFeatureRegistry.get(ModuleFluids.class).fluid(this.name().toLowerCase(Locale.ENGLISH)).flammability(flammability).viscosity(viscosity).density(density).temperature(this.getTemperature()).particleColor(particleColor).bucket(this::getBucket).create();
        this.bucket = this.hasBucket() ? ModFeatureRegistry.get(ModuleFluids.class).item(() -> new BucketItem(this::getFluid, new Item.Properties().func_200919_a(Items.field_151133_ar).func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)), "bucket_" + this.name().toLowerCase(Locale.ENGLISH)) : null;
        this.tag = new ResourceLocation("forestry", this.feature.getIdentifier());
    }

    protected boolean hasBucket() {
        return true;
    }

    public int getTemperature() {
        return 295;
    }

    public final ResourceLocation getTag() {
        return this.tag;
    }

    public FeatureFluid getFeature() {
        return this.feature;
    }

    @Nullable
    public FeatureItem<BucketItem> getBucketFeature() {
        return this.bucket;
    }

    @Nullable
    public BucketItem getBucket() {
        return this.bucket != null ? this.bucket.getItem() : null;
    }

    public final Fluid getFluid() {
        return this.feature.fluid();
    }

    public final Fluid getFlowing() {
        return this.feature.flowing();
    }

    public final FluidStack getFluid(int mb) {
        Fluid fluid = this.getFluid();
        if (fluid == Fluids.field_204541_a) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(fluid, mb);
    }

    public final Color getParticleColor() {
        return this.feature.properties().particleColor;
    }

    public final boolean is(Fluid fluid) {
        return this.getFluid() == fluid;
    }

    public final boolean is(FluidStack fluidStack) {
        return this.getFluid() == fluidStack.getFluid();
    }

    public static boolean areEqual(Fluid fluid, FluidStack fluidStack) {
        return fluid == fluidStack.getFluid();
    }

    @Nullable
    public static ForestryFluids getFluidDefinition(Fluid fluid) {
        return tagToFluid.get(fluid.getRegistryName());
    }

    @Nullable
    public static ForestryFluids getFluidDefinition(FluidStack fluidStack) {
        if (!fluidStack.isEmpty()) {
            return ForestryFluids.getFluidDefinition(fluidStack.getFluid());
        }
        return null;
    }

    public List<ItemStack> getOtherContainers() {
        return Collections.emptyList();
    }

    @Nullable
    public DrinkProperties getDrinkProperties() {
        return this.feature.properties().properties;
    }

    static {
        tagToFluid = new HashMap<ResourceLocation, ForestryFluids>();
        for (ForestryFluids fluidDefinition : ForestryFluids.values()) {
            tagToFluid.put(new ResourceLocation("forestry", fluidDefinition.feature.getIdentifier()), fluidDefinition);
        }
    }
}

