/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.fluids.EmptyFluidHandler;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.ForestryFluids;
import forestry.core.fluids.ITankManager;
import forestry.core.fluids.ITankUpdateHandler;
import forestry.core.fluids.StandardTank;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketTankLevelUpdate;
import forestry.core.render.EnumTankLevel;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.IRenderableTile;
import forestry.core.utils.NBTUtilForestry;
import forestry.core.utils.NetworkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TankManager
implements ITankManager,
ITankUpdateHandler,
IStreamable,
INbtWritable,
INbtReadable {
    private final List<StandardTank> tanks = new ArrayList<StandardTank>();
    private final Table<Container, Integer, FluidStack> prevFluidStacks = HashBasedTable.create();
    @Nullable
    private final ILiquidTankTile tile;
    private final List<EnumTankLevel> tankLevels = new ArrayList<EnumTankLevel>();

    public TankManager() {
        this.tile = null;
    }

    public TankManager(ILiquidTankTile tile, StandardTank ... tanks) {
        this.tile = tile;
        this.addAll(Arrays.asList(tanks));
    }

    public final boolean addAll(Collection<? extends StandardTank> collection) {
        boolean addedAll = true;
        for (StandardTank standardTank : collection) {
            addedAll &= this.add(standardTank);
        }
        return addedAll;
    }

    public boolean add(StandardTank tank) {
        boolean added = this.tanks.add(tank);
        int index = this.tanks.indexOf(tank);
        tank.setTankUpdateHandler(this);
        tank.setTankIndex(index);
        this.tankLevels.add(EnumTankLevel.rateTankLevel((IFluidTank)tank));
        return added;
    }

    @Override
    public CompoundNBT write(CompoundNBT data) {
        ListNBT tagList = new ListNBT();
        for (byte slot = 0; slot < this.tanks.size(); slot = (byte)((byte)(slot + 1))) {
            StandardTank tank = this.tanks.get(slot);
            if (tank.getFluid().isEmpty()) continue;
            CompoundNBT tag = new CompoundNBT();
            tag.func_74774_a("tank", slot);
            tank.writeToNBT(tag);
            tagList.add((Object)tag);
        }
        data.func_218657_a("tanks", (INBT)tagList);
        return data;
    }

    @Override
    public void read(CompoundNBT data) {
        NBTUtilForestry.NBTList tagList = NBTUtilForestry.getNBTList(data, "tanks", NBTUtilForestry.EnumNBTType.COMPOUND);
        Iterator iterator = tagList.iterator();
        while (iterator.hasNext()) {
            CompoundNBT tag = (CompoundNBT)iterator.next();
            byte slot = tag.func_74771_c("tank");
            if (slot < 0 || slot >= this.tanks.size()) continue;
            StandardTank tank = this.tanks.get(slot);
            tank.readFromNBT(tag);
            this.updateTankLevels(tank, false);
        }
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        for (StandardTank tank : this.tanks) {
            tank.writeData(data);
        }
    }

    @Override
    public void readData(PacketBufferForestry data) {
        for (StandardTank tank : this.tanks) {
            tank.readData(data);
        }
    }

    @Override
    public void containerAdded(Container container, IContainerListener player) {
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        List<IContainerListener> crafters = Collections.singletonList(player);
        for (StandardTank tank : this.tanks) {
            this.sendTankUpdate(container, crafters, tank);
        }
    }

    @Override
    public void containerRemoved(Container container) {
        for (StandardTank tank : this.tanks) {
            this.prevFluidStacks.remove((Object)container, (Object)tank.getTankIndex());
        }
    }

    @Override
    public void sendTankUpdate(Container container, List<IContainerListener> crafters) {
        for (StandardTank tank : this.tanks) {
            this.sendTankUpdate(container, crafters, tank.getTankIndex());
        }
    }

    private void sendTankUpdate(Container container, List<IContainerListener> crafters, int tankIndex) {
        StandardTank tank = this.tanks.get(tankIndex);
        if (tank == null) {
            return;
        }
        FluidStack fluidStack = tank.getFluid();
        FluidStack prev = (FluidStack)this.prevFluidStacks.get((Object)container, (Object)tankIndex);
        if (prev == null) {
            prev = FluidStack.EMPTY;
        }
        if (FluidHelper.areFluidStacksEqual(fluidStack, prev)) {
            return;
        }
        this.sendTankUpdate(container, crafters, tank);
    }

    private void sendTankUpdate(Container container, Iterable<IContainerListener> crafters, StandardTank tank) {
        if (this.tile != null) {
            int tankIndex = tank.getTankIndex();
            FluidStack fluid = tank.getFluid();
            PacketTankLevelUpdate packet = new PacketTankLevelUpdate(this.tile, tankIndex, fluid);
            for (IContainerListener crafter : crafters) {
                if (!(crafter instanceof ServerPlayerEntity)) continue;
                NetworkUtil.sendToPlayer(packet, (PlayerEntity)((ServerPlayerEntity)crafter));
            }
            if (fluid.isEmpty()) {
                this.prevFluidStacks.remove((Object)container, (Object)tankIndex);
            } else {
                this.prevFluidStacks.put((Object)container, (Object)tankIndex, (Object)fluid.copy());
            }
        }
    }

    @Override
    public void processTankUpdate(int tankIndex, @Nullable FluidStack contents) {
        if (tankIndex < 0 || tankIndex > this.tanks.size()) {
            return;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        tank.setFluid(contents);
    }

    @Override
    public IFluidTank getTank(int tankIndex) {
        return (IFluidTank)this.tanks.get(tankIndex);
    }

    public int getTanks() {
        return this.tanks.size();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tankIndex) {
        IFluidTank tank = this.getTank(tankIndex);
        if (tank == null) {
            return FluidStack.EMPTY;
        }
        return tank.getFluid();
    }

    public int getTankCapacity(int tankIndex) {
        IFluidTank tank = this.getTank(tankIndex);
        if (tank == null) {
            return 0;
        }
        return tank.getCapacity();
    }

    public boolean isFluidValid(int tankIndex, @Nonnull FluidStack stack) {
        IFluidTank tank = this.getTank(tankIndex);
        if (tank == null) {
            return false;
        }
        return tank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankAcceptsFluid(tank, resource)) continue;
            return this.fill(tank.getTankIndex(), resource, action);
        }
        return EmptyFluidHandler.INSTANCE.fill(resource, action);
    }

    public int fill(int tankIndex, FluidStack resource, IFluidHandler.FluidAction action) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size()) {
            return 0;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        if (!tank.canFill()) {
            return 0;
        }
        return tank.fill(resource, action);
    }

    @Override
    public void updateTankLevels(StandardTank tank) {
        this.updateTankLevels(tank, true);
    }

    private void updateTankLevels(StandardTank tank, boolean sendUpdate) {
        if (!(this.tile instanceof IRenderableTile)) {
            return;
        }
        int tankIndex = tank.getTankIndex();
        EnumTankLevel tankLevel = EnumTankLevel.rateTankLevel((IFluidTank)tank);
        if (tankLevel != this.tankLevels.get(tankIndex)) {
            this.tankLevels.set(tankIndex, tankLevel);
            if (sendUpdate) {
                PacketTankLevelUpdate tankLevelUpdate = new PacketTankLevelUpdate(this.tile, tankIndex, tank.getFluid());
                NetworkUtil.sendNetworkPacket(tankLevelUpdate, this.tile.getCoordinates(), this.tile.getWorldObj());
            }
        }
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankCanDrain(tank)) continue;
            return this.drain(tank.getTankIndex(), maxDrain, action);
        }
        return EmptyFluidHandler.INSTANCE.drain(maxDrain, action);
    }

    public FluidStack drain(int tankIndex, int maxDrain, IFluidHandler.FluidAction action) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size()) {
            return FluidStack.EMPTY;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        if (!tank.canDrain()) {
            return FluidStack.EMPTY;
        }
        return tank.drain(maxDrain, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankCanDrainFluid(tank, resource)) continue;
            return this.drain(tank.getTankIndex(), resource.getAmount(), action);
        }
        return FluidStack.EMPTY;
    }

    @Nullable
    public FluidStack getFluid(int tankIndex) {
        return this.tanks.get(tankIndex).getFluid();
    }

    @Override
    public boolean canFillFluidType(FluidStack fluidStack) {
        for (StandardTank tank : this.tanks) {
            if (!tank.isFluidValid(fluidStack)) continue;
            return true;
        }
        return false;
    }

    private static boolean tankAcceptsFluid(StandardTank tank, FluidStack fluidStack) {
        return tank.canFill() && tank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    private static boolean tankCanDrain(StandardTank tank) {
        if (!tank.canDrain()) {
            return false;
        }
        FluidStack drained = tank.drain(1, IFluidHandler.FluidAction.SIMULATE);
        return !drained.isEmpty() && drained.getAmount() > 0;
    }

    private static boolean tankCanDrainFluid(StandardTank tank, FluidStack fluidStack) {
        return ForestryFluids.areEqual(tank.getFluidType(), fluidStack) && TankManager.tankCanDrain(tank);
    }
}

