/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.IBreedingTracker;
import forestry.core.network.packets.PacketGenomeTrackerSync;
import forestry.core.utils.NetworkUtil;
import genetics.api.GeneticsAPI;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IIndividual;
import genetics.api.mutation.IMutation;
import genetics.api.root.IRootDefinition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;

public abstract class BreedingTracker
extends WorldSavedData
implements IBreedingTracker {
    private static final String SPECIES_COUNT_KEY = "SpeciesCount";
    private static final String MUTATIONS_COUNT_KEY = "MutationsCount";
    private static final String RESEARCHED_COUNT_KEY = "ResearchedCount";
    private static final String SPECIES_KEY = "SD";
    private static final String MUTATIONS_KEY = "MD";
    private static final String RESEARCHED_KEY = "RD";
    private static final String MODE_NAME_KEY = "BMS";
    private static final String MUTATION_FORMAT = "%s-%s=%s";
    private static final Collection<String> emptyStringCollection = Collections.emptyList();
    public static final String TYPE_KEY = "TYPE";
    private final Set<String> discoveredSpecies = new HashSet<String>();
    private final Set<String> discoveredMutations = new HashSet<String>();
    private final Set<String> researchedMutations = new HashSet<String>();
    private String modeName;
    @Nullable
    private GameProfile username;
    @Nullable
    private World world;

    protected BreedingTracker(String s, String defaultModeName) {
        super(s);
        this.modeName = defaultModeName;
    }

    public void setUsername(@Nullable GameProfile username) {
        this.username = username;
    }

    public void setWorld(@Nullable World world) {
        this.world = world;
    }

    @Override
    public String getModeName() {
        return this.modeName;
    }

    @Override
    public void setModeName(String name) {
        this.modeName = name;
        this.func_76185_a();
    }

    protected abstract IBreedingTracker getBreedingTracker(PlayerEntity var1);

    protected abstract String speciesRootUID();

    @Override
    public void synchToPlayer(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity && !(player instanceof FakePlayer)) {
            IBreedingTracker breedingTracker = this.getBreedingTracker(player);
            String modeName = breedingTracker.getModeName();
            this.setModeName(modeName);
            CompoundNBT CompoundNBT2 = new CompoundNBT();
            this.encodeToNBT(CompoundNBT2);
            PacketGenomeTrackerSync packet = new PacketGenomeTrackerSync(CompoundNBT2);
            NetworkUtil.sendToPlayer(packet, player);
        }
    }

    private void syncToPlayer(Collection<String> discoveredSpecies, Collection<String> discoveredMutations, Collection<String> researchedMutations) {
        PlayerEntity player;
        if (this.world != null && this.username != null && this.username.getName() != null && (player = this.world.func_217371_b(this.username.getId())) instanceof ServerPlayerEntity && !(player instanceof FakePlayer)) {
            IBreedingTracker breedingTracker = this.getBreedingTracker(player);
            String modeName = breedingTracker.getModeName();
            this.setModeName(modeName);
            CompoundNBT compound = new CompoundNBT();
            this.writeToNBT(compound, discoveredSpecies, discoveredMutations, researchedMutations);
            PacketGenomeTrackerSync packet = new PacketGenomeTrackerSync(compound);
            NetworkUtil.sendToPlayer(packet, player);
        }
    }

    @Override
    public void decodeFromNBT(CompoundNBT compound) {
        this.func_76184_a(compound);
    }

    @Override
    public void encodeToNBT(CompoundNBT compound) {
        this.func_189551_b(compound);
    }

    public void func_76184_a(CompoundNBT CompoundNBT2) {
        if (CompoundNBT2.func_74764_b(MODE_NAME_KEY)) {
            this.modeName = CompoundNBT2.func_74779_i(MODE_NAME_KEY);
        }
        BreedingTracker.readValuesFromNBT(CompoundNBT2, this.discoveredSpecies, SPECIES_COUNT_KEY, SPECIES_KEY);
        BreedingTracker.readValuesFromNBT(CompoundNBT2, this.discoveredMutations, MUTATIONS_COUNT_KEY, MUTATIONS_KEY);
        BreedingTracker.readValuesFromNBT(CompoundNBT2, this.researchedMutations, RESEARCHED_COUNT_KEY, RESEARCHED_KEY);
    }

    public CompoundNBT func_189551_b(CompoundNBT CompoundNBT2) {
        this.writeToNBT(CompoundNBT2, this.discoveredSpecies, this.discoveredMutations, this.researchedMutations);
        return CompoundNBT2;
    }

    private void writeToNBT(CompoundNBT CompoundNBT2, Collection<String> discoveredSpecies, Collection<String> discoveredMutations, Collection<String> researchedMutations) {
        if (this.modeName != null && !this.modeName.isEmpty()) {
            CompoundNBT2.func_74778_a(MODE_NAME_KEY, this.modeName);
        }
        CompoundNBT2.func_74778_a(TYPE_KEY, this.speciesRootUID());
        BreedingTracker.writeValuesToNBT(CompoundNBT2, discoveredSpecies, SPECIES_COUNT_KEY, SPECIES_KEY);
        BreedingTracker.writeValuesToNBT(CompoundNBT2, discoveredMutations, MUTATIONS_COUNT_KEY, MUTATIONS_KEY);
        BreedingTracker.writeValuesToNBT(CompoundNBT2, researchedMutations, RESEARCHED_COUNT_KEY, RESEARCHED_KEY);
    }

    private static void readValuesFromNBT(CompoundNBT CompoundNBT2, Set<String> values, String countKey, String key) {
        if (CompoundNBT2.func_74764_b(countKey)) {
            int count = CompoundNBT2.func_74762_e(countKey);
            for (int i = 0; i < count; ++i) {
                String value;
                if (!CompoundNBT2.func_74764_b(key + i) || (value = CompoundNBT2.func_74779_i(key + i)).isEmpty()) continue;
                values.add(value);
            }
        }
    }

    private static void writeValuesToNBT(CompoundNBT CompoundNBT2, Collection<String> values, String countKey, String key) {
        int count = values.size();
        CompoundNBT2.func_74768_a(countKey, count);
        Iterator<String> iterator = values.iterator();
        for (int i = 0; i < count; ++i) {
            String value = iterator.next();
            if (value == null || value.isEmpty()) continue;
            CompoundNBT2.func_74778_a(key + i, value);
        }
    }

    private static String getMutationString(IMutation mutation) {
        String species0 = mutation.getFirstParent().getRegistryName().toString();
        String species1 = mutation.getSecondParent().getRegistryName().toString();
        String resultSpecies = mutation.getResultingSpecies().getRegistryName().toString();
        return String.format(MUTATION_FORMAT, species0, species1, resultSpecies);
    }

    @Override
    public void registerMutation(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        if (!this.discoveredMutations.contains(mutationString)) {
            this.discoveredMutations.add(mutationString);
            this.func_76185_a();
            IRootDefinition speciesRoot = GeneticsAPI.apiInstance.getRoot(this.speciesRootUID());
            ForestryEvent.MutationDiscovered event = new ForestryEvent.MutationDiscovered(speciesRoot, this.username, mutation, this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.syncToPlayer(emptyStringCollection, Collections.singleton(mutationString), emptyStringCollection);
        }
    }

    @Override
    public boolean isDiscovered(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        return this.discoveredMutations.contains(mutationString) || this.researchedMutations.contains(mutationString);
    }

    @Override
    public boolean isDiscovered(IAlleleSpecies species) {
        return this.discoveredSpecies.contains(species.getRegistryName().toString());
    }

    public Set<String> getDiscoveredSpecies() {
        return this.discoveredSpecies;
    }

    @Override
    public int getSpeciesBred() {
        return this.discoveredSpecies.size();
    }

    @Override
    public void registerBirth(IIndividual individual) {
        this.registerSpecies(individual.getGenome().getPrimary());
        this.registerSpecies(individual.getGenome().getSecondary());
    }

    @Override
    public void registerSpecies(IAlleleSpecies species) {
        String registryName = species.getRegistryName().toString();
        if (!this.discoveredSpecies.contains(registryName)) {
            this.discoveredSpecies.add(registryName);
            IRootDefinition speciesRoot = GeneticsAPI.apiInstance.getRoot(this.speciesRootUID());
            ForestryEvent.SpeciesDiscovered event = new ForestryEvent.SpeciesDiscovered(speciesRoot, this.username, species, this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.syncToPlayer(Collections.singleton(registryName), emptyStringCollection, emptyStringCollection);
        }
    }

    @Override
    public void researchMutation(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        if (!this.researchedMutations.contains(mutationString)) {
            this.researchedMutations.add(mutationString);
            this.func_76185_a();
            this.registerMutation(mutation);
            this.syncToPlayer(emptyStringCollection, emptyStringCollection, Collections.singleton(mutationString));
        }
    }

    @Override
    public boolean isResearched(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        return this.researchedMutations.contains(mutationString);
    }
}

