/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.core.tooltips.ToolTip;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.apiculture.DisplayHelper;
import forestry.core.items.ItemForestry;
import genetics.api.GeneticHelper;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismType;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemGE
extends ItemForestry {
    protected ItemGE(Item.Properties properties) {
        super(properties.setNoRepair());
    }

    protected abstract IAlleleForestrySpecies getSpecies(ItemStack var1);

    protected abstract IOrganismType getType();

    public boolean func_77645_m() {
        return false;
    }

    public ITextComponent func_200295_i(ItemStack itemStack) {
        if (GeneticHelper.getOrganism(itemStack).isEmpty()) {
            return super.func_200295_i(itemStack);
        }
        IAlleleForestrySpecies species = this.getSpecies(itemStack);
        return species.getItemName(this.getType());
    }

    public boolean func_77636_d(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        IAlleleForestrySpecies species = this.getSpecies(stack);
        return species.hasEffect();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (!itemstack.func_77942_o()) {
            return;
        }
        Optional<IIndividual> optionalIndividual = GeneticHelper.getIndividual(itemstack).filter(IIndividual::isAnalyzed);
        if (optionalIndividual.isPresent()) {
            IIndividual individual = optionalIndividual.get();
            if (Screen.func_231173_s_()) {
                ToolTip toolTip = new ToolTip();
                DisplayHelper.getInstance().getTooltips(individual.getRoot().getUID(), this.getType()).forEach(provider -> provider.addTooltip(toolTip, individual.getGenome(), individual));
                list.addAll(toolTip.getLines());
                if (toolTip.isEmpty()) {
                    individual.addTooltip(list);
                }
            } else {
                list.add((ITextComponent)new TranslationTextComponent("for.gui.tooltip.tmi", new Object[]{"< %s >"}).func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC));
            }
        } else {
            list.add((ITextComponent)new TranslationTextComponent("for.gui.unknown", new Object[]{"< %s >"}).func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Nullable
    public String getCreatorModId(ItemStack itemStack) {
        IAlleleForestrySpecies species = this.getSpecies(itemStack);
        return species.getRegistryName().func_110624_b();
    }
}

